function [mcmc, output ] = ptsgr( mcmc, output, data, Init )

if strcmp(mcmc.Restart,'No');
     
     mcmc.iter_loop=1;
     
     mcmc.it_update = mcmc.it_update - 1; % Change this to get nice iteration numbers in first loop
    
    [ ~] = InitializeInput(mcmc.nt, Init); % Create input files
    
    % Now create the intitial model(s) by unconditional simulation
    out=zeros(mcmc.nt,mcmc.nx*mcmc.ny);
    str0='unc_'; % Unconditional simulation / use str0='con' for Conditional simulation
    tic
    parfor i=1:mcmc.nt
        out(i,:)=runDS(i,str0);
    end
    toc
    for i=1:mcmc.nt
        mcmc.m_current{i}=reshape(out(i,:),mcmc.nx,mcmc.ny);
    end
    
    % Create output directory
    output.start_dir=pwd;
    output.str_dir=[output.store_dir,'\',sprintf('%s_mcmc_trial%s',datestr(now,'YYYYmmdd_HHMM'))];
    output.str_dir_fname=sprintf('%s_mcmc_trial%s',datestr(now,'YYYYmmdd_HHMM'));
     
    mkdir(output.str_dir);
    cd(output.str_dir);
    addpath(['..',filesep]);
    
    for i=1:mcmc.nt
        output.fname_asc{i}=sprintf('%s_ch_%d%s',output.str_dir_fname,i,'.asc');
          fid=fopen(output.fname_asc{i},'w');
          fclose(fid);
    end
    
    % And write first model(s) to disk
    for i=1:mcmc.nt
        fid=fopen(output.fname_asc{i},'a+');
        fprintf(fid,' %10.7g ',[mcmc.iter,mcmc.m_current{i}(:)']);
        fprintf(fid,'\n');
        fclose(fid);
    end
    cd(output.start_dir);
    
    % Now run the forward model
    tic
    [d]=run_forward(mcmc.m_current,mcmc.example);
    toc
    
    % Write simulated data to disk
    cd(output.str_dir);
    for i=1:mcmc.nt
        output.sname_asc{i}=sprintf('%s_sim_%d%s',output.str_dir_fname,i,'.asc');
        fid=fopen(output.sname_asc{i},'w');
        fclose(fid);
    end
    
    for i=1:mcmc.nt
        fid=fopen(output.sname_asc{i},'a+');
        fprintf(fid,' %10.7g ',[mcmc.iter,d{i}']);
        fprintf(fid,'\n');
        fclose(fid);
    end
    cd(output.start_dir);
    
    % Store current simulated data evaluate log-likelihood
    for i=1:mcmc.nt
        mcmc.d{i}=d{i};
        [log_lik_current(i),lik_current(i)]=CompLik(d{i},data);
        mcmc.log_lik(mcmc.iter,i)=log_lik_current(i);
        mcmc.lik(mcmc.iter,i)=lik_current(i);
    end
   
else
	current_dir=cd;
	cd(output.str_dir);
    load temp_results; mcmc.Restart='Yes';
	cd(current_dir)
end

% Now loop over the allowed number of iterations per chain
while mcmc.iter < mcmc.it_max
   
    for i=1:mcmc.nt % Set acceptance counters to zero
        tot_acc_isr(i)=0;
        if strcmp(mcmc.DoPT,'Yes'); % Do parallel tempering
            tot_acc_swap(i)=0; % This one is for parallel tempering
        end
    end
    if strcmp(mcmc.DoPT,'Yes'); % Do parallel tempering
        index_swap_step=zeros(1,mcmc.it_update);
    end
    
    % loop over i=1:mcmc.it_update
    for i=1:mcmc.it_update
        % create proposal in each tempered chain
        % conditional simulation followed by temperature swapping, if swap: random or neighboring swap
        update='isr';
       
        % Various strategies for efficient step length variations
        if strcmp(mcmc.use_phi_dist,'Gaussian')
            stdev= mcmc.phi_cv.*mcmc.phi;% coefficient of variation (CV): sigma/mu
            phi_used=mcmc.phi+randn(size(mcmc.phi)).*stdev;
            phi_used=min(phi_used,mcmc.phi_max);phi_used=max(phi_used,mcmc.phi_min);
        elseif strcmp(mcmc.use_phi_dist,'Triangular')
            for qq=1:length(mcmc.phi)
                [phi_used(qq)] = trirnd(mcmc.phi_min(qq),mcmc.phi(qq),mcmc.phi_max(qq),1);
            end
        elseif strcmp(mcmc.use_phi_dist,'Uniform') % uniform draw between phi_min and phi_max
            phi_used=mcmc.phi_min + (mcmc.phi_max - mcmc.phi_min).*rand(size(mcmc.phi));
            mcmc.phi=phi_used; % to that to keep track of the used phi later on
        else
            phi_used=mcmc.phi;
        end
       
        cond_type=mcmc.cond_type;
  
        [ ~] = SetInput(mcmc.nt, cond_type,phi_used,mcmc.m_current,'No'); % Generate conditioning dataset from current model in each chain
        % Now create the proposal model(s) by conditional simulation
        out=zeros(mcmc.nt,mcmc.nx*mcmc.ny);
        str0='con_'; % Conditional simulation
        tic
        parfor j=1:mcmc.nt
            out(j,:)=runDS(j,str0);
        end
        toc
        for j=1:mcmc.nt
            mcmc.m_propose{j}=reshape(out(j,:),mcmc.nx,mcmc.ny);
        end
         
    %-----------------------------------------------------------------  
        % Now run the forward model
        tic
        [d]=run_forward( mcmc.m_propose,mcmc.example);
        toc
        % Update counters
        mcmc.fe=mcmc.fe+mcmc.nt;
        mcmc.iter=mcmc.iter+1;
        
        % And evaluate log-likelihood
        log_lik_prop=zeros(1,mcmc.nt);lik_prop=zeros(1,mcmc.nt);
        for j=1:mcmc.nt
            [log_lik_prop(j),lik_prop(j)]=CompLik(d{j},data);
        end
        
        % Accept/reject using standard Metropolis-Hastings ratio
        Z=rand(mcmc.nt,1); alfa=zeros(mcmc.nt,1);
       
        for j=1:mcmc.nt
             alfa(j) = exp( 1/mcmc.temp(j) * (log_lik_prop(j)-log_lik_current(j)) );
             if alfa(j)>Z(j) % Move to proposed state
                mcmc.log_lik(mcmc.iter,j) =  log_lik_prop(j);
                mcmc.lik(mcmc.iter,j) = lik_prop(j);
                mcmc.m_current{j}= mcmc.m_propose{j};
                mcmc.d{j}=d{j};
                tot_acc_isr(j)=tot_acc_isr(j)+1;
                log_lik_current(j)=log_lik_prop(j);
                lik_current(j)=lik_prop(j);
                output.acc_history(mcmc.iter-1,j)=1;
                
            else % Remain at current position
                mcmc.log_lik(mcmc.iter,j) =  log_lik_current(j);
                mcmc.lik(mcmc.iter,j) = lik_current(j);
                output.acc_history(mcmc.iter-1,j)=0;
            end
        end
        % if strcmp(mcmc.DoPT,'Yes') && 1==1 ; % Do parallel tempering, the 1==1 is there to allow for future implementation of the option where pt is not performed at each iteration
        if strcmp(mcmc.DoPT,'Yes') && rand(1,1)<=mcmc.proba_swap ;    
            index_swap_step(i)=1;
            mcmc.i_swap_step=mcmc.i_swap_step+1;
            output.swap_pair_history(mcmc.i_swap_step,1)=mcmc.iter;
            output.acc_swap_history(mcmc.i_swap_step,1)=mcmc.iter;
            
            if strcmp(mcmc.pt_swap,'Random') % Random temperature swapping
                update='Random swap';
                disp(update),
                rr = randperm(mcmc.nt);
                T = floor(mcmc.nt/2); Z_temp = rand(T,1); alfa_swap=zeros(mcmc.nt,1);
            elseif strcmp(mcmc.pt_swap,'Neighbor_all')
                update='Neighbor swap - all at once';
				disp(update),
                if mod(mcmc.iter,2)~=0 % Test this to avoid having always the two same neighbors swapping
                    rr = 1:1:mcmc.nt;
                else
                    rr = [2:mcmc.nt-1,1,mcmc.nt];
                end
                
                T = floor(mcmc.nt/2); Z_temp = rand(T,1); alfa_swap=zeros(mcmc.nt,1);
            elseif strcmp(mcmc.pt_swap,'Neighbor')
                update='Neighbor swap';
                disp(update),
                T=1;
                %T=mcmc.nt-1;
                Z_temp = rand(T,1);
                alfa_swap=zeros(mcmc.nt,1);
                Z=zeros(mcmc.nt,1);
            end
            for j = 1:T;
                % Determine the pair of chains to be swapped
                if strcmp(mcmc.pt_swap,'Random') || strcmp(mcmc.pt_swap,'Neighbor_all')
                    ich_1 = rr( 2 * (j-1) + 1); ich_2 = rr( 2 * j );
                elseif strcmp(mcmc.pt_swap,'Neighbor')
                    if length(T)==1
                        jsel = randomsample(1:1:mcmc.nt-1,1);
                        rr = [jsel,jsel+1];
                    else
                        jsel = T+1-j;
                        rr = [jsel,jsel-1];
                    end
                    ich_1=rr(1);
                    ich_2=rr(2);
                end
                % And swap
                mcmc.m_propose_swap{ich_1}=mcmc.m_current{ich_2};
                
                mcmc.m_propose_swap{ich_2}=mcmc.m_current{ich_1};
                
                log_lik_prop_swap(ich_1)=log_lik_current(ich_2);
                lik_prop_swap(ich_1)=lik_current(ich_2);
                
                log_lik_prop_swap(ich_2)=log_lik_current(ich_1);
                lik_prop_swap(ich_2)=lik_current(ich_1);
                
                d{ich_1} = mcmc.d{ich_2};
                d{ich_2} = mcmc.d{ich_1};
                
                % Probability of a jump from ich_1 to ich_2
                alfa_swap(ich_1)=exp( (1/mcmc.temp(ich_1) * (log_lik_current(ich_2)-log_lik_current(ich_1))) ...
                    + (1/mcmc.temp(ich_2) * (log_lik_current(ich_1) - log_lik_current(ich_2))) ) ;
                
                % Associated jump from ich_2 to ich_1 - equal to alfa(ich_1)
                alfa_swap(ich_2)=alfa_swap(ich_1);
                
                % Now create Z
                Z(ich_1,1) = Z_temp(j); Z(ich_2,1) = Z_temp(j);
                % And record the swapping pair
                output.swap_pair_history(mcmc.i_swap_step,ich_1+1)=ich_2;
                output.swap_pair_history(mcmc.i_swap_step,ich_2+1)=ich_1;
            end
            for j=1:mcmc.nt
             
                if alfa_swap(j)>Z(j) % Accept swap
                    mcmc.log_lik(mcmc.iter,j) =  log_lik_prop_swap(j);
                    mcmc.lik(mcmc.iter,j) = lik_prop_swap(j);
                    mcmc.m_current{j}= mcmc.m_propose_swap{j};
                    mcmc.d{j}=d{j};
                    tot_acc_swap(j)=tot_acc_swap(j)+1;
                    log_lik_current(j)=log_lik_prop_swap(j);
                    lik_current(j)=lik_prop_swap(j);
                    output.acc_swap_history(mcmc.i_swap_step,j+1)=1;
                else % Remain at current position
                    % Do nothing
                    output.acc_swap_history(mcmc.i_swap_step,j+1)=0;
                end
            end
        end
        % Check if model(s) and associated simulated data need to be written to disk
        if (mod(mcmc.iter,mcmc.it_write) == 0),
            cd(output.str_dir);
            % Write model(s) to disk
            for j=1:mcmc.nt
                fid=fopen(output.fname_asc{j},'a+');
                fprintf(fid,' %10.7g ',[mcmc.iter,mcmc.m_current{j}(:)']);
                fprintf(fid,'\n');
                fclose(fid);
            end
            % Write associated simulated data to disk
            for j=1:mcmc.nt
                fid=fopen(output.sname_asc{j},'a+');
                fprintf(fid,' %10.7g ',[mcmc.iter,d{j}']);
                fprintf(fid,'\n');
                fclose(fid);
            end
            cd(output.start_dir);
        end
    end
    
    % Update mean acceptance rates
    output.ar_isr(mcmc.iter_loop,1:end)=[mcmc.iter 100*(tot_acc_isr./mcmc.it_update)];
    if strcmp(mcmc.DoPT,'Yes');
        output.ar_swap(mcmc.iter_loop,1:end)=[mcmc.iter 100*(tot_acc_swap./sum(index_swap_step))];
    end
    
    if mcmc.iter <= mcmc.it_update_max && ~strcmp(mcmc.use_phi_dist,'Uniform') && ~strcmp(mcmc.use_phi_dist,'Fixed')
        % Update phi (vanishing adaptation, only for the first n iterations)
        for i=1:mcmc.nt
            mcmc.phi(i)=UpdatePhi(mcmc.phi(i),mcmc.phi_max(i),mcmc.phi_min(i),mcmc.target_ar,output.ar_isr(mcmc.iter_loop,i+1),mcmc.cond_type);
        end
        % TODO update temperature ladder (vanishing adaptation or not, only for the first n iterations)
    end
    output.hist_phi(mcmc.iter_loop,1:end)=[mcmc.iter mcmc.phi];
    
    mcmc.iter_loop=mcmc.iter_loop + 1;
    
    if mcmc.iter_loop == 2 
        mcmc.it_update = mcmc.it_update + 1; % Correct this after first internal loop
    end
    
    cd(output.str_dir);
    save temp_results
    cd(output.start_dir);
   
end


