function [ d_cond ] = GenCond(idx,cond_type,phi,D)

[nx,ny,nz]=size(D);
x=[1:1:nx];
y=[1:1:ny];
z=[1:1:nz];
[yy,xx,zz]=meshgrid(y,x,z);

if cond_type==1;
    % random selection
    N=prod(size(xx));
    n_cond=ceil(phi.*N); % phi is the fraction of conditioning data
    ih=randomsample(N,n_cond);
    d_cond=[xx(ih(:)) yy(ih(:)) zz(ih(:)) D(ih(:))];
elseif cond_type==2;
    % Box type selection, taken from the SIPPI toolbox of Hansen et al. (2013) - works herein for 2D images only
    lim(1)=phi;lim(2)=phi; % phi defines half the side length of the box that is resimulated (the larger phi, the smaller the number of conditioning data, phi is actually half the box side length)
    
     pos(1)=min(x)+rand(1)*(max(x)-min(x));
     pos(2)=min(y)+rand(1)*(max(y)-min(y));
     pos(3)=min(z)+rand(1)*(max(z)-min(z));
    
    used=ones(size(xx));
    used(find( (abs(xx-pos(1))<lim(1)) & (abs(yy-pos(2))<lim(2)) ))=0;
    ih=find(used);
   
    % Classical selection (appears to induce some model degradation due to the interaction 
    % of very small phi values with likelihood maximimzation)
    
    d_cond=[xx(ih) yy(ih) zz(ih) D(ih)];
    
    
% elseif cond_type==3;
%     lim(1)=round(phi);lim(2)=round(phi); % phi is the side length of the box that is resimulated
%     xc_up_left=randsample([1:1:nx-lim(1)+1],1);
%     yc_up_left=randsample([1:1:ny-lim(1)+1],1);
%     used=ones(size(xx));
%     used(xc_up_left:xc_up_left+lim(1)-1,yc_up_left:yc_up_left+lim(1)-1)=0;
%     ih=find(used);
%     d_cond=[yy(ih) xx(ih) zz(ih) D(ih)];
end
%-----------------------------------------------------------    
%     rr=sqrt(phi)/3 + rand(1)*(sqrt(phi)*3-sqrt(phi)/3);
%     lim(1)=0.5*rr;lim(2)=0.5*(phi/rr);
%     pos(1)=min(x)+rand(1)*(max(x)-min(x));
%     pos(2)=min(y)+rand(1)*(max(y)-min(y));
%     pos(3)=min(z)+rand(1)*(max(z)-min(z));
%     
%     used=ones(size(xx));
%     used(find( (abs(xx-pos(1))<lim(1)) & (abs(yy-pos(2))<lim(2)) ))=0;
%     ih=find(used);
%   
%     % Classical selection (appears to induce some model degradation due to the interaction 
%     % of very small phi values with likelihood maximimzation)
%     
%     d_cond=[yy(ih) xx(ih) zz(ih) D(ih)];
%     
%     % % Test this for avoiding the model degradation phenomena:
%     % % pick only a (large) random fraction, phi_cf, of the points in the non-resimulated area
%     
% %     ih_sel=randomsample(length(ih),round(phi_cf*length(ih)));ih_sel=sort(ih_sel)';
% %     d_cond=[yy(ih(ih_sel)) xx(ih(ih_sel)) zz(ih(ih_sel)) D(ih(ih_sel))];


% Make sure there is a least one conditioning datum, otherwise the MPS code might complain
if isempty(d_cond) % Should not happen normally
     N=prod(size(xx));
    ih=randomsample(N,1);
     d_cond=[xx(ih) yy(ih) zz(ih) D(ih)];
end

str=['cond_',num2str(idx),'.dat'];
nvar=1;
line01=num2str(size(d_cond,1));
line02=num2str(nvar+3);
line03='X';
line04='Y';
line05='Z';
line06='facies';
fid = fopen(str,'w');
fprintf(fid,'%s \r\n',line01);
fprintf(fid,'%s \r\n',line02);
fprintf(fid,'%s \r\n',line03);
fprintf(fid,'%s \r\n',line04);
fprintf(fid,'%s \r\n',line05);
fprintf(fid,'%s \r\n',line06);
for i=1:size(d_cond,1)
    fprintf(fid,'%e %e %e %e \r\n',d_cond(i,:));
end
fclose(fid);
%eval(['save d_cond_',num2str(idx),'.mat d_cond;']);
end



