function [dummy] = InitializeInput(nc,Init)


dummy=1;
% Init = 'Yes' creates all the stuff
% Init = 'No' only randomly set the random seed to be used by the C executable
if strcmp(Init,'Yes') % create nc copies of the original input file that handle conditioning data
    
    % Input file(s) used for conditional simulation
    str1='test_con.in';
    for i=1:nc
        str2=['test_con_',num2str(i),'.in'];
        if exist(str2,'file');
            delete(str2);
        end
         copyfile(str1,str2);
    end
    
    % Input file(s) used for unconditional simulation
    str1='test_unc.in';
    for i=1:nc
        str2=['test_unc_',num2str(i),'.in'];
        if exist(str2,'file');
            delete(str2);
        end
         copyfile(str1,str2);
    end
end
% Loop over input file(s) used for conditional simulation    
for i=1:nc
    % Rewrite part(s) of the nc input files: 
    str_name=['test_con_',num2str(i),'.in'];
    str_file = fileread(str_name);  % Remember strings
    fid = fopen(str_name,'r+');
    for iline = 1:32
        dummy=fgetl(fid);
    end
    old_str_0=fgetl(fid); % Name of output data file 
    new_str_0=['test_',num2str(i),'_simul'];
    
    for iline = 34:37
        dummy=fgetl(fid);
    end
    old_str_1=fgetl(fid); % Name of report file 
    new_str_1=['test_report_',num2str(i),'.txt'];
    
    for iline = 39:54
        dummy=fgetl(fid);
    end
    old_str_2=fgetl(fid); % Name of conditioning data file 
    new_str_2=['cond_',num2str(i),'.dat'];
    
    for iline = 56:322
        dummy=fgetl(fid);
    end
    old_str_3=fgetl(fid); % Random seed
    seed_num=1+ceil(rand(1)*(1e6-100));
    new_str_3=num2str(seed_num);
    fclose(fid); % exit
    
    if strcmp(Init,'Yes') 
        str_file = strrep(str_file, old_str_0, new_str_0); % Replace name of output data file 
        str_file = strrep(str_file, old_str_1, new_str_1); % Replace name of report file
        str_file = strrep(str_file, old_str_2, new_str_2); % Replace name of conditioning data file
    end
    str_file = strrep(str_file, old_str_3, new_str_3); % Replace random seed
    fid = fopen(str_name, 'w'); % And rewrite
    fwrite(fid, str_file, '*char');
    fclose(fid);  
end

% Loop over input file(s) used for unconditional simulation    
for i=1:nc
    % Rewrite part(s) of the nc input files: 
    str_name=['test_unc_',num2str(i),'.in'];
    str_file = fileread(str_name);  % Remember strings
    fid = fopen(str_name,'r+');
    for iline = 1:32
        dummy=fgetl(fid);
    end
    old_str_0=fgetl(fid); % Name of output data file 
    new_str_0=['test_',num2str(i),'_simul'];
    for iline = 34:322
        dummy=fgetl(fid);
    end
    old_str_1=fgetl(fid); % Random seed
    seed_num=1000+ceil(rand(1)*(1e7-1000));
    new_str_1=num2str(seed_num);
    fclose(fid); % exit
    if strcmp(Init,'Yes') 
        str_file = strrep(str_file, old_str_0, new_str_0); % Replace name of output data file 
    end
    str_file = strrep(str_file, old_str_1, new_str_1); % Replace random seed
    fid = fopen(str_name, 'w'); % And rewrite
    fwrite(fid, str_file, '*char');
    fclose(fid);  
end


