%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%   fCropArray   Do cropping of the data
%
%     arrayOut = fCropArray( arrayIn, newNy, newNx );
%
%     INPUT:   arrayIn  Array to crop 
%              newNy    Final dimension along the y-axis
%              newNx    Final dimension along the x-axis
%
%     OUTPUT:  arrayOut Cropped array
%
%     NOTE:    The centre of the data is at the indice 
%                   - Odd data length:  (N+1)/2
%                   - Even data length: (N/2)+1
%              This is equivalent to calculating: floor(N/2)+1
%              Works for both even and odd data...
%
% (c) Jerome Yerly 2010

function arrayOut = fCropNdArray( arrayIn, newN )

  % Number of dimension in arrayIn
    Ndim = length(size(arrayIn));
    
  % newN should be an array of length equal to the number of dimension in
  % arrayIn
    if length(newN) ~= Ndim
        arrayOut = arrayIn;
        return;
    end
    
  % Get dimension of array to crop
    oldN = size( arrayIn );
    
  % Initialize the padded array
    arrayOut = zeros( newN );
    
  % Calculate the old and new indice corresponding to the centre of the
  % data
    idxCtr_old = floor( oldN / 2 ) + 1;
    idxCtr_new = floor( newN / 2 ) + 1;

  % Calculate the start indices where to place the centred data
    idxStart = idxCtr_old - idxCtr_new + 1;
    
  % Calculate the end indices where to place the centred data
    idxEnd = idxStart + newN - 1;
    
  % Loop through all dimension to generate indices
    for i = 1:Ndim
        
      % Construct command
        str = sprintf('idx%d = idxStart(%d) : idxEnd(%d);', i, i, i);
        
      % Eval command
        eval(str);
        
    end
    
  % Initialize string for command
    tmpStr = '';
    
  % Loop through all dimension to construct the next command
    for i = 1:Ndim
        
        if i == 1
          % Construct string for next command
            tmpStr = sprintf('idx%d ', i);
        else
          % Construct string for next command
            tmpStr = sprintf('%s, idx%d ', tmpStr, i);
        end
    end
    
  % Construct command
    str = sprintf('arrayOut = arrayIn(%s);', tmpStr);
    
  % Eval command
    eval(str);


        