// header-only code. No macros
#ifndef UTILS_HH_
#define UTILS_HH_

#if __cplusplus >= 201103L
#include<type_traits>
#endif
#include<string>
#include<iostream>
#include<sstream>
#include<vector>
#include<cstdlib>

namespace utils {

template<typename T>
inline    std::string one_thing_to_str(T           x) {
    std::ostringstream oss; oss << x; return oss.str();
}

template<typename T>
std::string to_str(const T &t0) {
    return    one_thing_to_str(t0);
}
template<typename T0
        ,typename T1
>
std::string to_str(const T0 &t0
                  ,const T1 &t1
        ) {
    return one_thing_to_str(t0)
         + one_thing_to_str(t1)
         ;
}
template<typename T0
        ,typename T1
        ,typename T2
>
std::string to_str(const T0 &t0
                  ,const T1 &t1
                  ,const T2 &t2
        ) {
    return one_thing_to_str(t0)
         + one_thing_to_str(t1)
         + one_thing_to_str(t2)
         ;
}
template<typename T0
        ,typename T1
        ,typename T2
        ,typename T3
>
std::string to_str(const T0 &t0
                  ,const T1 &t1
                  ,const T2 &t2
                  ,const T3 &t3
        ) {
    return one_thing_to_str(t0)
         + one_thing_to_str(t1)
         + one_thing_to_str(t2)
         + one_thing_to_str(t3)
         ;
}
template<typename T0
        ,typename T1
        ,typename T2
        ,typename T3
        ,typename T4
>
std::string to_str(const T0 &t0
                  ,const T1 &t1
                  ,const T2 &t2
                  ,const T3 &t3
                  ,const T4 &t4
        ) {
    return one_thing_to_str(t0)
         + one_thing_to_str(t1)
         + one_thing_to_str(t2)
         + one_thing_to_str(t3)
         + one_thing_to_str(t4)
         ;
}
template<typename T0 ,typename T1 ,typename T2
        ,typename T3 ,typename T4 ,typename T5
>
std::string to_str(const T0 &t0 ,const T1 &t1 ,const T2 &t2
                  ,const T3 &t3 ,const T4 &t4 ,const T5 &t5
        ) {
    return one_thing_to_str(t0) + one_thing_to_str(t1) + one_thing_to_str(t2) + one_thing_to_str(t3)
         + one_thing_to_str(t4) + one_thing_to_str(t5)
         ;
}
template<typename T0 ,typename T1 ,typename T2
        ,typename T3 ,typename T4 ,typename T5, typename T6
>
std::string to_str(const T0 &t0 ,const T1 &t1 ,const T2 &t2
                  ,const T3 &t3 ,const T4 &t4 ,const T5 &t5, const T6 &t6
        ) {
    return one_thing_to_str(t0) + one_thing_to_str(t1) + one_thing_to_str(t2) + one_thing_to_str(t3)
         + one_thing_to_str(t4) + one_thing_to_str(t5) + one_thing_to_str(t6)
         ;
}

inline
bool exit_with_error(int status, std:: string error_message) {
    std::cerr << error_message << std::endl;
    exit(status);
    return false; // shouldn't ever actually get here
}

struct vec_of_vecs {
    std::vector<double> m_data;
    int length_of_one_row; // i.e. number of columns
    int other_length;
    explicit
    vec_of_vecs(int rows, int cols) : length_of_one_row(cols), other_length(rows) {
        m_data.resize( rows * cols );
    }
    double & operator() (int row, int col) {
        col >= 0 || exit_with_error(10, "Column index [" + one_thing_to_str(col) + to_str("] too small"));
        return m_data.at( row * length_of_one_row + col );
    }
    double   operator() (int row, int col) const {
        col >= 0 || exit_with_error(10, std::string("Column index [") + one_thing_to_str(col) + std::string("] too small"));
        return m_data.at( row * length_of_one_row + col );
    }
    double & operator() (int row, int col, int check_length) {
        check_length == length_of_one_row || exit_with_error(10,
           to_str("length_of_one is wrong: ["
                , length_of_one_row
                , "], expected ["
                , check_length
                , "]"
           ));
        return (*this)(row, col);
    }
    operator double *() { return &m_data.front(); }
#if __cplusplus >= 201103L
    template <typename T>
    operator T* () const = delete;
//#else
    //template <typename T>
    //operator T* () const;
#endif
};
inline
std:: ostream& operator<<(std:: ostream &o, const vec_of_vecs &vv) {
    for (int r = 0; r<vv.other_length; ++r) {
        if(r==0)
            o << "[[";
        else
            o << " [";
        for (int c = 0; c<vv.length_of_one_row; ++c) {
            if(c!=0)
                o << ",\t";
            o << vv(r,c);
        }
        o << "]";
        if(r+1 < vv.other_length)
            o << '\n';
        else
            o << ']';
    }

    return o;
}
template<typename T>
std:: ostream& operator<<(std:: ostream &o, const std::vector<T> &v) {
    o << '[';
    for(typename std::vector<T>::iterator it = v.cbegin(); it != v.cend(); ++it) {
        if(it != v.begin())
            o << "\t,";
        o << *it;
    }
    o << ']';
    return o;
}

} // namespace utils
#endif
