#ifndef QUICKTEST_H
#define QUICKTEST_H

#include <cstring>
#include <vector>
#include <list>
using namespace std;


inline int randInt (int N) {
  return(min(int(unif_rand() * N), N-1));
}

inline double pow2 (double x) {
  return(x*x);
}

inline double pow4 (double x) {
  double xx = x*x;
  return(xx*xx);
}

struct strEq
{
  bool operator()(const char* s1, const char* s2) const
  {
    return strcmp(s1, s2) == 0;
  }
};

class pheno
{
public:
  int idx;
  double val;
};

struct phenoLess :
  public binary_function<pheno, pheno, bool> { 
  bool operator()(pheno y1, pheno y2) { return(y1.val < y2.val); }
};

class io_spec {
public:
  list<string>* genotypeFilelist;
  string genotypeFilename;
  string phenotypeFilename;
  string nPheno; // name or number of phenotype to analyse
  list<string>* nCovar; // names or numbers of covariates
  bool specialOoopsLine; // whether there is a special `0 0 0 P P...' line a la SNPTEST
  bool specialMissingCode;
  string missingCode;
  bool exclusions;
  string exclusionsFilename;
  bool ignoreTies;
  string outputFilename;
  bool progress; // whether to print progress message
  bool quantileNormalise;
  bool mixhint;
  string mixhintFilename;

  io_spec() {
    genotypeFilelist = new list<string>;
    genotypeFilename = "";
    phenotypeFilename = "";
    nPheno = "1";
    nCovar = new list<string>;
    specialOoopsLine = false;
    specialMissingCode = false;
    missingCode = "";
    exclusions = false;
    exclusionsFilename = "";
    ignoreTies = false;
    outputFilename = "";
    progress = true;
    quantileNormalise = false;
    mixhint = false;
    mixhintFilename = "";
  }
};

// class containing all options and parameters about statistical
// methods to be applied
class method_spec {
public:
  bool copy;
  bool copycalls;
  bool copydose;
  bool rSqHat;
  bool alphaHat;
  bool normal;
  bool mix;
  bool qqnormal;
  bool call;
  bool mean;
  bool score;
  bool ML;
  bool MCMC;
  bool poe;
  bool multiSNP;

  bool binary;
  double binThresh;

  bool interaction;
  bool robust;

  bool Hardy;
  bool MAF;

  bool Pettitt;
  string copyFilename;
  double callThresh;
  int seed1;
  int seed2;
  bool test;
  double testBeta;
  int mixBigK;
  bool mixCentered;

  method_spec () {
    copy = false;
    copycalls = false;
    copydose = false;
    rSqHat = false;
    alphaHat = false;
    normal = true;
    mix = false;
    qqnormal = false;
    call = false;
    mean = false;
    score = false;
    ML = false;
    MCMC = false;

    poe = false;
    multiSNP = false;

    binary = false;
    binThresh = 0.;

    interaction = false;
    robust = false;

    Hardy = false;
    MAF = false;

    Pettitt = false;
    copyFilename = "";
    callThresh = 0.9;
    seed1 = 1;
    seed2 = 1;
    test = false;
    testBeta = 0.;
    mixBigK = 0;
    mixCentered = false;
  }


};

#endif /* QUICKTEST_H */
