#!/bin/bash
set -e

QUICKTEST=../quicktest

# simple analysis using normal mean and normal score methods
$QUICKTEST --geno example1.bgen    --pheno example1.pheno \
    --method-mean --method-score --compute-rSqHat --out ex1a.out  --bgen

# same analysis using SNPTEST-format input file
$QUICKTEST --geno example1.bgen    --pheno example1.sample --snptest \
    --method-mean --method-score --compute-rSqHat --out ex1b.out  --bgen

# example GxE
$QUICKTEST --geno example1.bgen    --pheno multivar1.pheno \
    --npheno ldl --ncovar bmi --method-mean --method-interaction \
    --compute-rSqHat --out ex1c.out  --bgen

# example logistic regression
$QUICKTEST --geno example1.bgen    --pheno multivar1.pheno \
    --npheno ldl --ncovar sex --ncovar smoke --method-binary 4 \
    --compute-rSqHat --out ex1d.out  --bgen
