function [name_links common_names unique_names1 unique_names2] = match_names(names1, names2)

% get unique names from both name lists
[unique_names1 dummy idx1] = unique(names1);
[unique_names2 dummy idx2] = unique(names2);

length1 = length(unique_names1);
length2 = length(unique_names2);

% do matching using the 'intersect' function
[common_names, i1, i2] = intersect(unique_names1,unique_names2);

% build link matrix
unique_name_links = sparse(length1, length2);
unique_name_links(length1*(i2-1)+i1) = 1;

% expand for non-unique entries
name_links = unique_name_links(idx1,:);
name_links = name_links(:,idx2);
