function [x se r2 invH] = est_totvar_theor(fo,fo0,fso0,n0,alph,hm)

global P o o0 so0

if nargin<6
    hm = 50;
end
if nargin<5
    alph = 1E-2;
end

pMinLim = log(-log10(alph));
p_lim = [10.^-exp(linspace(pMinLim,5,hm)) 0];

%%%%%%%%%%%%%%%%%%%%%%%%
hn = 1;

lr2_lim = linspace(-5,-2.5,hn+1);
x0 = (lr2_lim(2:end)+lr2_lim(1:end-1))/2;
z_lim = norminv(p_lim/2);
r0 = sqrt(10.^x0);
r2 = r0.^2;

Q1 = zeros(hm,hn);
Q2 = Q1;
for i=1:hn
    Q1(:,i) = normcdf(z_lim(1:end-1)'+r0(i)*sqrt(n0));
    Q2(:,i) = normcdf(z_lim(2:end)'+r0(i)*sqrt(n0));    
end
ncdf = Q1-Q2;

ncdf(ncdf<1e-3) = 0;
c = find(max(ncdf,[],2)>0);
o = fo(c);
o0 = fo0(c);
so0 = fso0(c,c);
t = o-o0;

P = ncdf(c,:);
sol = max(1e-2,P\t);
options = optimset('Display','off','MaxFunEval',1e4,'MaxIter',1e3);
[xlog flog exitf output grad hess] = fminunc(@loglikP_vec_new,log10(sol),options);
sol = 10.^xlog;

for hmh=1:4
    
    hn = 2^hmh;
    solz = zeros(hn,1);
    solz(1:2:end) = sol;
    solz(2:2:end) = sol;
    sol = solz/2;

    lr2_lim = linspace(-5,-2.5,hn+1);
    x0 = (lr2_lim(2:end)+lr2_lim(1:end-1))/2;
    z_lim = norminv(p_lim/2);

    r0 = sqrt(10.^x0);
    r2 = r0.^2;
    Q1 = zeros(hm,hn);
    Q2 = Q1;
    for i=1:hn
        Q1(:,i) = normcdf(z_lim(1:end-1)'+r0(i)*sqrt(n0));
        Q2(:,i) = normcdf(z_lim(2:end)'+r0(i)*sqrt(n0));    
    end
    ncdf = Q1-Q2;

    ncdf(ncdf<1e-3) = 0;
    c = find(max(ncdf,[],2)>0);
    o = fo(c);
    o0 = fo0(c);
    so0 = fso0(c,c);
    P = ncdf(c,:);

    [xlog flog exitf output grad hess] = fminunc(@loglikP_vec_new,log10(sol),options);
    sol = 10.^xlog;

end

% nsz = find(xlog<=-1);
% xlog(nsz) = -Inf;
% tmp = hessian(@loglikP_vec,xlog);
% Hlog = zeros(hn);
% Hlog(sz,sz) = tmp(sz,sz);
% invHlog = zeros(hn);
% invHlog(sz,sz) = inv(Hlog(sz,sz));

x = 10.^xlog;
Hexp = hessian(@loglikP_vec_exp_new,x);
sz = find(xlog>0 & diag(Hexp)<1);
H = zeros(hn);
H(sz,sz) = Hexp(sz,sz);
invH = zeros(hn);
invH(sz,sz) = inv(H(sz,sz));
    
mu = r2*x;
se = sqrt(r2*(invH*r2'));
err_x = sqrt(diag(invH));

% ir = find(p_lim<5e-6,1,'first');
% r2_sub = sum(P(ir:end,:),1).*r2;
% mu0 = r2_sub*x;
% se0 = sqrt(r2_sub*(invH*r2_sub'));
