function [a,b] = golden(f,a,b,eps,N)
% Maria Guell i Pons
% Cours Matlab - ALGORITHMES OPTIMISATION: "Golden Search"
% Minimisation de la fonction f en [a,b] 
% f est continue on [a,b]
% f est unimodal (juste un minimum en [a,b])
% N est le nombre maxime d'itrations
% Critre arret: b-a < eps

%Nombre d'or
c = (-1+sqrt(5))/2;
inia=a;
inib=b;

%Calcul x1,x2,f(x1),f(x2)
x1 = c*a + (1-c)*b;
fx1 = feval(f,x1);
x2 = (1-c)*a + c*b;
fx2 = feval(f,x2);

%Sorties graphiques
fprintf('------------------------------------------------------\n');
fprintf(' x1 x2 f(x1) f(x2) b - a\n');
fprintf('------------------------------------------------------\n');
fprintf('%.4e %.4e %.4e %.4e %.4e\n', x1, x2, fx1, fx2, b-a);

for i = 1:N-2

%Cas 1: f(x1)<f(x2)
if fx1 < fx2
b = x2;
x2 = x1;
fx2 = fx1;
x1 = c*a + (1-c)*b;
fx1 = feval(f,x1);

%Cas 2: f(x1)>f(x2)
else
a = x1;
x1 = x2;
fx1 = fx2;
x2 = (1-c)*a + c*b;
fx2 = feval(f,x2);
end;

fprintf('%.4e %.4e %.4e %.4e %.4e\n', x1, x2, fx1, fx2, b-a);

%Critre d'arrt
if (abs(b-a) < eps)
fprintf('Convergence aprs %d iterations\n', i);
return;
end;

%Graphiques erreur
axisx(i)=i+1;
axisy(i)=abs(b-a);
figure (2)
plot(axisx,axisy,'-or')
title('Optimisation: Algorithme Golden Search')
xlabel('Nombre Iterations')
ylabel('Erreur')

end;
%Message non convergence
fprintf('Non convergence aprs %d iterations\n', N);

