%%%%% TP MATLAB 24.11.2009 %%%%%%%% FICHIER PRINCIPALE %%%%%%%%%%%%%%%%%%
% 
% 
% 
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Lecture de l'image, storez la comme 'double' dans im_originale:

% im_originale = double(imread('circularCrops.jpg'));

im_originale = sub_zh1;
im_originale = standardimg(im_originale,2);

% PREMIERE VARIANTE: Transformation de l'image de couleurs  chelles de 
% gris: ACP. Faites une ACP ([coeff composantes] = princomp(image)) de 
% l'image im_originale. La fonction 'princomp' prend en paramtres l'image 
% avec les bandes en colonnes (utilisez 'reshape', la matrice de MxNxT
% devient M*N,T).

[s1 s2 s3] = size(im_originale);

imm_colonna = reshape(im_originale,s1*s2,s3);
[a b] = princomp(imm_colonna);
PC1 = reshape(b(:,1),s1,s2);
PC1 = standardimg(PC1,2);
imshow(PC1);

% faite un reshape et visualisez la premire composante et l'image 
% originale (imshow(image,colormap(gray(255)))). Nommez cette composante 
% GR, on va la sauvegarder (imwrite) comme une image  chelle de gris. 

% Nommez im2filter l'image  filtrer.

im2filter = 

% Ici on va insrer les 3 autres fonctions qu'on va crer dans d'autres
% file .m. 
% Ces fonction prennent en paramtre l'lment structurant SE,  crer
% avant d'appeler la fonction.
% la variable p_switch sert pour utiliser une fonction 'switch ..case' dans
% le trois fonctions, de faon que quand p_switch = 'erode' la fonction
% erode l'image. Si p_switch = 'dilate', la mme foncion dilatera l'image
% prise en paramtre. 

SE = strel('disk',20,0);

% im_filtre = erode_dilate(im2filter,SE,'dilate');
% im_filtre = open_close(im2filter,SE,'close');

im_filtre1 = op_cl_recon(im2filter,SE,'op_recon');
im_filtre2 = op_cl_recon(im2filter,SE,'cl_recon');

        % TIP: pour contrler l'iteration utilisez une boucle 'while' qui tourne
        % jusqu' quand une valeur de contrle (disons CO) reste gale  1
        % (CO == 1). Lorsque l'image  l'iteration prcedente et l'image
        % obtenue  l'iteration courante sont gales, donne la valeur 0 
        % CO et la boucle arrte de tourner. 
        
% DEUXIEME VARIANTE: on utilise toute le 4 bandes de l'image. 

        imfilt = zeros(s1,s2,s3);
        for i = 1:s3
        imfilt1(:,:,i) = op_cl_recon(im2filter(:,:,i),SE,'op_recon');
        imfilt2(:,:,i) = op_cl_recon(im2filter(:,:,i),SE,'cl_recon');
        end
        

% Visualisez le images filtrs et sauvegardez les. Pour visualiser une
% image de ce type (scal entre 0 et 1) ou avec des chiffres uint8 ou
% uint16, utilisez la fonction imshow(image,cmap). Si la visualisation se
% fait de faon binaire (noir et blanc) alors que l'image est  chelle de 
% gris, spcifiez une colormap correcte (e.g. cmap = colormap(gray(256)))  
% pour une image uint8). Pour visualiser l'image en couleurs (si la matrice 
% est plus grande qu'une MxNx3) specifiez les bandes avec un vecteur
% d'indices (e.g. figure; imshow(IMAGE(:,:,[4 2 1]));).

subplot(131), imshow(im2filter)
subplot(132), imshow(im_filtre1)
subplot(133), imshow(im_filtre2)

imwrite(im_filtre2,'im_filtered_cl_recon.tif')

% Aprs une verification des trois fonctions, regroupezles dans une seule
% fonction et nommez la filtres_morphologiques. Cette fonction prend en
% paramtre l'image, l'SE et le paramtre indiquant quelle fonction doit
% appliquer. ( la base, copiez-collez les 'case' qu'on a switch dans les 
% autres fonctions).

% Optionnel: pour avoir une ide de q'est ce qe fait la fonction
% op_cl_recon, lancez la fonction example_ocr(image,par) (avec 
% une image  chelle de gris et par = 'op_recon' || 'cl_recon';). 
% Une squence d'images vous montrera comme les filtres godsiques 
% aggissent sur l'image.

% im_filtered = example_ocr(im2filter,'op_recon');


