clear all
close all

load('DEM250mRomandie.mat');

Altitude = dem250m(:,:,3);
NewAltitude = Altitude;

% Image filter
Filter = ones(3,3);
Filter = Filter*1/9;
NewAltitude = imfilter(NewAltitude,Filter);
figure
imagesc(NewAltitude);

% Auto convolution
NewAltitude2 = Altitude;
NewAltitude2 = conv2(NewAltitude2,Filter);
figure
imagesc(NewAltitude2);

% Comparison
[rows cols] = size(Altitude);
Diff = NewAltitude2(2:rows+1,2:cols+1)-NewAltitude;
figure
imagesc(Diff);

% Filter loop
[rows cols] = size(Altitude);
NewAltitude3 = Altitude;
Filter = ones(3,3);
Filter = Filter*1/9;
for i=1:100
    NewAltitude3 = imfilter(NewAltitude3,Filter);
end
figure
imagesc(NewAltitude3);