clear all
close all

load('DEM250mRomandie.mat');

Altitude = dem250m(:,:,3);
NewAltitude = Altitude;

% Auto convolution
Filter = ones(3,3);
Filter = Filter*1/9;
NewAltitude = conv2(NewAltitude,Filter);
figure
imagesc(NewAltitude);

% Manual convolution
[rows cols] = size(Altitude);
NewAltitude2 = Altitude;
for rowi = 2:rows-1
    for coli = 2:cols-1
        NewAltitude2(rowi,coli) = mean(mean(Altitude(rowi-1:rowi+1,coli-1:coli+1)));
    end
end
figure
imagesc(NewAltitude2);

% Comparison
Diff = NewAltitude(2:rows+1,2:cols+1)-NewAltitude2;
figure
imagesc(Diff);

% Convolution loop
[rows cols] = size(Altitude);
NewAltitude3 = Altitude;
Filter = ones(3,3);
Filter = Filter*1/9;
for i=1:100
    NewAltitude3 = conv2(NewAltitude3,Filter);
end
figure
imagesc(NewAltitude3);