function [portee] = tirbalistique_f2(alphadeg, V0kmh, z0)
%TIRBALISTIQUE   Tir balistique.
%   TIRBALISTIQUE(alphadeg, V0kmh) calcul la portée correspondante à l'angle 
%   alphadeg (degrés), à la vitesse initiale V0kmh (km/h) et à la hauteur
%   initiale z0 (m)

alpha = pi*alphadeg/180;
V0 = V0kmh/3.6;

% Entrer l'interval de résolution des x
x0 = [0,10e6];
% Résoudre la fonction
[z, fval] = fsolve(@(x) trajectoire(V0,alpha,x,z0),x0);

portee = z;


function z = trajectoire(V0,alpha,x,z0)

z = -(1/2)*9.81*(x.^2) / (V0*cos(alpha))^2 + x.*tan(alpha) + z0;