function VarCell = PrepareAnalysis(SearchField, SearchStr, System, FixedPath)
%% Function to get experiments parameters from the database and prepare the files for the analysis
%SearchField: String containing the name of the field to serach in
%SearchStr: String that contains characters to search for
%  or cell that contains multiple strings to search for
%System defines on which system the analysis will be run: mac mac_para, pc, pc_para
%the xx_para will run on the appriopriate system with the matlab
%paralleltoolbox
%Cluster was defined for runs on the brutus cluster. Not sure if it is
%still working
%Fixed path can provide a special path where the analysis can be run

%Example:VarCell = PrepareAnalysis( 'Filename', '0326_Hog1_WT', 'mac')
%		 VarCell = PrepareAnalysis( 'ExpNum', [22:25], 'pc_para')

%% Initiate routine by setting directory and getting required inputs
%Add path to folder containing all routines
try
BaseDir = cd;
addpath(fullfile(BaseDir, 'CommonProcess'))
%Load database connection settings from install process
Var = load('DatabaseConnexionParameter.mat');
javaaddpath(Var.Database.DriverPath)
load('ImageStoragePath.mat');
catch
    error('Could not find DatabaseConnextionParameter.mat or ImageStoragePath.mat. Verify that these files are in the CommonProcess folder')
end

%% Dialog for getting the parameters
%If search argument for database not provided display dialog box
if nargin == 0
    DialogPrompt = {'Enter Search Field (Folder, Filename):','Enter Search String:'};
    DialogTitle = 'Input for Database search';
    DialogDef = {'Filename','{0326_Hog1_WT}'};
    DialogAnswer = inputdlg(DialogPrompt, DialogTitle,1 ,DialogDef);
    
    Var.Database.SearchField = DialogAnswer{1};
    Var.Database.SearchStr = DialogAnswer{2};
else
    Var.Database.SearchField = SearchField;
    Var.Database.SearchStr = SearchStr;
end

%Select system to run the analysis
if nargin < 3
    System = questdlg('Select system to run the analysis','System choice','PC_Para','PC','Mac','PC_Para') ;
end

%% Check if Search field is Exp num and convert to numeric if necessary
if strcmp(SearchField,'ExpNum') &&  ~isnumeric(SearchStr)
    Commas = strfind(SearchStr, ',');
    Commas = [1,Commas,length(SearchStr)];
    for c = 1:length(Commas)-1
        SearchNum(c) = str2num(SearchStr(Commas(c)+1:Commas(c+1)-1));
    end
    Var.Database.SearchStr = SearchNum;
end



try

%% Get Experiments Data from database connection
Var.Database.Table = 'Experiment';
Var = DatabaseConnections(Var);
%assignin('base', 'Var', Var)

%% Iteration variable to build the cell
iter = 0;
for R = 1:Var.Database.NumFoundRecord
    %Distribute database fields into VarRec
    VarRec = Var;
    VarRec = GetDBFields(VarRec, R);
    %% Read Analysis info from database
    VarRec.Database.Table = 'Analysis';
    VarRec.Database.SearchField = 'AnalysisNum';
    VarRec.Database.SearchStr = VarRec.Experiment.LinkedAnalysisNum;
    %Get analysis flow parameters from database
    VarRec = DatabaseConnections(VarRec);

    %Distribute database fields into VarRec
    VarRec = GetDBFields(VarRec, 1);
    
    VarRec.Analysis.System = System;
    
    
    %Get server folder path for window and Mac platform
    %from the ImageStoragePath file
    %Use local if you run the process on the local machine
    
    VarRec.Analysis.MacServerBase = ImageStoragePath.MAC;
    VarRec.Analysis.PCServerBase =  ImageStoragePath.PC;

    
    %For system running in parallel no movies can be saved jpg of each
    %frame will be saved instead
    if ~isempty(strfind(VarRec.Analysis.System, 'para'))
        VarRec.Analysis.SaveAvi = 'No';
    else
        VarRec.Analysis.SaveAvi = 'Yes';
    end
    
    
    %Find Pathformat of DB Folder entry
    if strcmp(VarRec.Analysis.MacServerBase, 'local')
        %Keep current path if no server path is specified
        VarRec.Analysis.MacPath = VarRec.Experiment.Folder;
        VarRec.Analysis.PCPath = VarRec.Experiment.Folder;
    else
        FindMacSep = strfind(VarRec.Experiment.Folder, '/');
        if ~isempty(FindMacSep)
            VarRec.Analysis.MacPath = VarRec.Experiment.Folder;
            VarRec.Analysis.PCPath = Mac2PC(VarRec.Experiment.Folder, VarRec.Analysis.PCServerBase);
        else
            VarRec.Analysis.PCPath = VarRec.Experiment.Folder;
            VarRec.Analysis.MacPath = PC2MAC(VarRec.Experiment.Folder, VarRec.Analysis.MacServerBase);
        end
    end

    %assignin('base', 'Var_2', VarRec)
    
    %% Read segmentation settings from database
    VarRec.Database.Table = 'SegmentationParameters';
    VarRec.Database.SearchField = 'FullName';
    if isfield(VarRec.Analysis, 'SegYFPara')
        % ShStr = [VarRec.Analysis.SegYFPara{1},'_',num2str(VarRec.Experiment.Objective),'x_bin', num2str(VarRec.Experiment.Bin)]
        VarRec.Database.SearchStr = [VarRec.Analysis.SegYFPara{1},'_',num2str(VarRec.Experiment.Objective),...
            'x_bin', num2str(VarRec.Experiment.Bin)];
        VarRec = DatabaseConnections(VarRec);
        %Distribute database fields into VarRec
        VarRec = GetDBFields(VarRec, 1);
    end
    if isfield(VarRec.Analysis, 'SegAroundPara')
        VarRec.Database.SearchStr = [VarRec.Analysis.SegAroundPara{1},'_',num2str(VarRec.Experiment.Objective),...
            'x_bin', num2str(VarRec.Experiment.Bin)];
        VarRec = DatabaseConnections(VarRec);
        %Distribute database fields into VarRec
        VarRec = GetDBFields(VarRec, 1);
    end
    if isfield(VarRec.Analysis, 'SegPhasePara')
        VarRec.Database.SearchStr = [VarRec.Analysis.SegPhasePara{1},'_',num2str(VarRec.Experiment.Objective),...
            'x_bin', num2str(VarRec.Experiment.Bin)];
        VarRec = DatabaseConnections(VarRec);
        %Distribute database fields into VarRec
        VarRec = GetDBFields(VarRec, 1);
    end
    
    
    %% Assign figure numbers depending on analysis type
    VarRec = FigureFlow(VarRec);
    %assignin('base', 'Var_3', VarRec)
    %% Creat Cell array containing data for each parrallel analysis
    %Get Number of position from Experiment parameters
    VarRec.Analysis.NumPos = VarRec.Experiment.LastPos{length(VarRec.Experiment.LastPos)};
    %Get Well number and condition from experiment data
    LineNum = 1;
    for P = 1:VarRec.Analysis.NumPos
        
        VarRec.Analysis.CurrentPos = P;
        if P >= VarRec.Experiment.FirstPos{LineNum} && P <= VarRec.Experiment.LastPos{LineNum}
            VarRec.Analysis.CurrentWell =  VarRec.Experiment.Well{LineNum};
            VarRec.Analysis.CurrentCondition =  VarRec.Experiment.Condition{LineNum};
        else
            LineNum = LineNum+1;
            if P >= VarRec.Experiment.FirstPos{LineNum} && P <= VarRec.Experiment.LastPos{LineNum}
                VarRec.Analysis.CurrentWell =  VarRec.Experiment.Well{LineNum};
                VarRec.Analysis.CurrentCondition =  VarRec.Experiment.Condition{LineNum};
            else
                error('Position number not found in position range from experiment')
            end
        end
        

        
        %Read Image variable from files and define image path and output
        %path
        %Change the folder Path depending on platform where the analysis preparation is performed
        if ismac
            VarRec.Experiment.Folder = VarRec.Analysis.MacPath;
        elseif ispc
            VarRec.Experiment.Folder = VarRec.Analysis.PCPath;
        end
        %Populate VarCell with current Variable for the record
        iter = iter + 1;
        VarCell{iter}{1} = VarRec;
        
        %Get Image parameter from image folder and add to Cell
        [VarCell{iter}{1}] = ReadImgParameters(VarCell{iter}{1});
        
    end
    
end
catch LastErr
    VarRec.error = LastErr;
    assignin('base','VarRec_Error',VarRec);
    %Save VarRec file
    Time = clock;
    TimeStr = [num2str(Time(1)),num2str(Time(2),'%02d'),num2str(Time(3),'%02d'),'_',num2str(Time(4),'%02d'),num2str(Time(5),'%02d')];
    save(fullfile(BaseDir,['ERROR_',TimeStr,'.mat']), 'VarRec')
end


%% Save Cell array depending on analysis platform used
try
%If a fixed path string has been defined replace comon server base path
if nargin == 4
    if ~isempty(find(FixedPath, '/'))
        Var.Analysis.MacServerBase = FixedPath;
    else
        Var.Analysis.PCServerBase = FixedPath;
    end
end


if strcmp(VarRec.Analysis.MacServerBase, 'local')
    %Save VarCell with same path as the one use for ANalysis preparation
    [Path, CellName] = fileparts(VarCell{1}{1}.Experiment.Folder);
    CellName = ['VarCell_', CellName, '.mat'];
    save(fullfile(VarCell{1}{1}.Experiment.Folder,CellName) , 'VarCell');
else
    %If required modify path names in VarCell to appropriate platform based on
    %ServerBase name
    if strcmpi(System, 'mac') || strcmpi(System, 'mac_para')
        %For analysis on Mac save VarCell in first experiment folder
        if ismac
            [Path, CellName] = fileparts(VarCell{1}{1}.Experiment.Folder);
            CellName = ['VarCell_', CellName, '.mat'];
            save(fullfile(VarCell{1}{1}.Experiment.Folder,CellName) , 'VarCell');
        else ispc
            %Modify filenames for images to adjust path from PC to Mac
            for C = 1:length(VarCell)
                
                VarCell{C}{1}.Analysis.OutPath = PC2MAC(VarCell{C}{1}.Analysis.OutPath, VarCell{C}{1}.Analysis.MacServerBase);
                
                %Replace path for FilePath variable
                if iscell(VarCell{C}{1}.Analysis.FilePath)
                    [M, N] = size(VarCell{C}{1}.Analysis.FilePath);
                    for m = 1:M
                        for n = 1:N
                            VarCell{C}{1}.Analysis.FilePath{m,n} = PC2MAC(VarCell{C}{1}.Analysis.FilePath{m,n}, VarCell{C}{1}.Analysis.MacServerBase);
                        end
                    end
                else
                    VarCell{C}{1}.Analysis.FilePath = PC2MAC(VarCell{C}{1}.Analysis.FilePath, VarCell{C}{1}.Analysis.MacServerBase);
                end
                
            end
            [Path, CellName] = fileparts(VarCell{1}{1}.Experiment.Folder);
            CellName = ['VarCell_', CellName, '.mat'];
            save(fullfile(VarCell{1}{1}.Experiment.Folder,CellName) , 'VarCell');
        end
        
    elseif strcmpi(System, 'PC') || strcmpi(System, 'PC_para')
        %For analysis on PC save VarCell in first experiment folder
        if ispc
            [Path, CellName] = fileparts(VarCell{1}{1}.Experiment.Folder);
            CellName = ['VarCell_', CellName, '.mat'];
            save(fullfile(VarCell{1}{1}.Experiment.Folder,CellName) , 'VarCell');
        elseif ismac
            for C = 1:length(VarCell)
                VarCell{C}{1}.Analysis.OutPath = Mac2PC(VarCell{C}{1}.Analysis.OutPath, VarCell{C}{1}.Analysis.PCServerBase);
                
                %Replace path for FilePath variable
                if iscell(VarCell{C}{1}.Analysis.FilePath)
                    [M, N] = size(VarCell{C}{1}.Analysis.FilePath);
                    for m = 1:M
                        for n = 1:N
                            VarCell{C}{1}.Analysis.FilePath{m,n} = Mac2PC(VarCell{C}{1}.Analysis.FilePath{m,n}, VarCell{C}{1}.Analysis.PCServerBase);
                        end
                    end
                else
                    VarCell{C}{1}.Analysis.FilePath = Mac2PC(VarCell{C}{1}.Analysis.FilePath, VarCell{C}{1}.Analysis.PCServerBase);
                end
            end
            [Path, CellName] = fileparts(VarCell{1}{1}.Experiment.Folder);
            if isempty(CellName)
                [Path, CellName] = fileparts(Path);
            end
            
            CellName = ['VarCell_', CellName, '.mat'];
            save(fullfile(VarCell{1}{1}.Experiment.Folder,CellName) , 'VarCell');
        end
        
    end
end
catch LastErr
    VarCell{1}{1}.error = LastErr;
    assignin('base','VarCell_Error',VarCell);
    %Save VarRec file
    Time = clock;
    TimeStr = [num2str(Time(1)),num2str(Time(2),'%02d'),num2str(Time(3),'%02d'),'_',num2str(Time(4),'%02d'),num2str(Time(5),'%02d')];
    save(fullfile(BaseDir,['ERROR_',TimeStr,'.mat']), 'VarCell')
end





%% Transform MAC to PC files %%%%%%%%%%%%%%%%%%%

function PCOut = Mac2PC(Path, PCbase)

%Replace FilePath and OutPath with PC server path
%Find PC Folder name (Should match one of the folder name in the
%original path
if ~isempty(Path)

Sep = strfind(PCbase, '\');
NewRoot = PCbase(1:Sep(end));
if Sep(end) == length(PCbase)
    CommonFolder = PCbase(Sep(end-1)+1:end-1);
else
    CommonFolder = PCbase(Sep(end)+1:end);
end
%Go up the path to find the same folder in the Mac path
[OldRoot, UpFolder] = fileparts(Path);
%Loop through all folders until match is found between PC and mac
%folder name
while ~strcmp(UpFolder, CommonFolder)
    PrevRoot = OldRoot;
    [OldRoot, UpFolder] = fileparts(PrevRoot);
    if isempty(UpFolder)
        error(['Error generating MAC path: No Match found between ',Path 'and  ', PCbase])
    end
end
%Replace path for OutPath variable
PCOut = [NewRoot,Path(length(PrevRoot)+2:end)];
PCOut = regexprep(PCOut, '/', '\');
else
    PCOut = [];

end
%% Transform PC to MAC files %%%%%%%%%%%%%%%%%%%



function MacOut = PC2MAC(Path, Macbase)

%Replace FilePath and OutPath with PC server path
%Find PC Folder name (Should match one of the folder name in the
%original path
if ~isempty(Path)
    
Sep = strfind(Macbase, '/');
NewRoot = Macbase(1:Sep(end));

if Sep(end) == length(PCbase)
    CommonFolder = Macbase(Sep(end-1)+1:end-1);
else
    CommonFolder = Macbase(Sep(end)+1:end);
end
%Go up the path to find the same folder in the Mac path
[OldRoot, UpFolder] = fileparts(Path);
%Loop through all folders until match is found between PC and mac
%folder name
while ~strcmp(UpFolder, CommonFolder)
   PrevRoot = OldRoot;
    [OldRoot, UpFolder] = fileparts(PrevRoot);
    if isempty(UpFolder)
        error(['Error generating PC path: No Match found between ',Path 'and  ', Macbase])
    end
end
%Replace path for OutPath variable
MacOut = [NewRoot,Path(length(PrevRoot)+2:end)];
MacOut = regexprep(MacOut, '\', '/');
else
    MacOut = [];

end

