% Transfer multiple folders acquired with the Multi-dimensional GUI in Micro-manager into a single folder with more positions


%Main directory
ROOT = '/Volumes/share-gr-peter-1-$/Frank/110608';
%Folders to Move
FolderIN = {'Triple_R_t4_A_0', 'Triple_R_t4_B_0', 'Triple_R_t4_C_0','Triple_R_t4_D_0', 'Triple_R_t4_E_0', 'Triple_R_t4_F_0','Triple_R_t4_G_0', 'Triple_R_t4_H_0'};
%Folder which will recieve the files
FolderOUT = 'Triple_R_t4';


mkdir(ROOT,FolderOUT)
NumPos = 0;
for F = 1:length(FolderIN)
    FolderF = fullfile(ROOT, [FolderIN{F},filesep,'Pos*']);
    ListPosFolders= dir(FolderF);
    for P = 1:length(ListPosFolders)
        NumPos = NumPos +1;
        
        PosFolderIN = fullfile(ROOT, FolderIN{F}, ListPosFolders(P).name);
        PosFolderOUT = fullfile(ROOT,FolderOUT , ['Pos',num2str(NumPos,'%02d')]);
        
        movefile(PosFolderIN,PosFolderOUT)
        
        Transfer{NumPos,1} = [FolderIN{F}, filesep, ListPosFolders(P).name];
         Transfer{NumPos,2} = [FolderOUT, filesep,'Pos',num2str(NumPos,'%02d')];
    end
end
save(fullfile(ROOT,FolderOUT,'Transfer.mat'), 'Transfer')
        
    
    