function VarOUT = ChangePathInData(VarIN);

% Change file path in Data.mat files

NewPath = '/Users/serge/Publications/YeastQuant/YeastQuant_Program/Data/0517_Stl1qVqC';
OldPath = '\\nas-biol-bc.ethz.ch\share-gr-peter-1-$\Serge\YeastQuant_Program\Data\0517_Stl1qVqC';
System = 'Mac';  %or 'PC'


%Replace Back slashes:
NewPath = regexptranslate('escape', NewPath);
OldPath = regexptranslate('escape', OldPath);

%Duplicate VarIN
VarOUT = VarIN;
%loop through all file names to modify them
for i = 1:size(VarIN.Analysis.FilePath,1)
    for t = 1:size(VarIN.Analysis.FilePath,2)
        %Get old file
        OldFile = VarIN.Analysis.FilePath{i,t};
        
        %Change directory
        NewFile = regexprep(OldFile, OldPath, NewPath);
        
        %Change file separator
        if strcmpi(System, 'Mac')
            FS = regexptranslate('escape', '\');
            NewFile = regexprep(NewFile, FS, '/');
            
             if i == 1&& t == 1
            VarOUT.Analysis.MacPath = regexprep(VarIN.Analysis.MacPath, OldPath, NewPath);
             VarOUT.Analysis.MacPath = regexprep( VarOUT.Analysis.MacPath, FS, '/');
             
             VarOUT.Analysis.OutPath = regexprep(VarIN.Analysis.OutPath, OldPath, NewPath);
             VarOUT.Analysis.OutPath = regexprep( VarOUT.Analysis.OutPath, FS, '/');
             end
        elseif strcmpi(System, 'PC')
            NewFile = regexprep(NewFile, '/','\');
            
            if i == 1&& t == 1
            VarOUT.Analysis.PCPath = regexprep(VarIN.Analysis.PCPath, OldPath, NewPath);
             VarOUT.Analysis.PCPath = regexprep( VarOUT.Analysis.PCPath, '/','\');
             
             VarOUT.Analysis.OutPath = regexprep(VarIN.Analysis.OutPath, OldPath, NewPath);
             VarOUT.Analysis.OutPath = regexprep( VarOUT.Analysis.OutPath, '/','\');
            end
        end
        %Add file to structure
        VarOUT.Analysis.FilePath{i,t} = NewFile;
    end
end