function varargout = LimitPrefs(varargin)
% LIMITPREFS M-file for LimitPrefs.fig
%      LIMITPREFS, by itself, creates a new LIMITPREFS or raises the existing
%      singleton*.
%
%      H = LIMITPREFS returns the handle to a new LIMITPREFS or the handle to
%      the existing singleton*.
%
%      LIMITPREFS('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in LIMITPREFS.M with the given input arguments.
%
%      LIMITPREFS('Property','Value',...) creates a new LIMITPREFS or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before LimitPrefs_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to LimitPrefs_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help LimitPrefs

% Last Modified by GUIDE v2.5 24-Oct-2011 22:13:44

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
    'gui_Singleton',  gui_Singleton, ...
    'gui_OpeningFcn', @LimitPrefs_OpeningFcn, ...
    'gui_OutputFcn',  @LimitPrefs_OutputFcn, ...
    'gui_LayoutFcn',  [] , ...
    'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before LimitPrefs is made visible.
function LimitPrefs_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to LimitPrefs (see VARARGIN)

% Choose default command line output for LimitPrefs
handles.output = hObject;

GUI_handle = findobj('Name','Export2Meas');
Main_handles = guidata(GUI_handle);

handles.Display = Main_handles.Display;
handles.Export = Main_handles.Export;
handles.Limit.Properties = {'Mean'; 'Median';  'Basal'; 'Final';'MaxDiff'};
 
assignin('base','Main_handles',Main_handles);
for L = 1:5
    % If limits already specified:
    if isfield(Main_handles, 'Limit') && length(Main_handles.Limit.Meas)>=L
        if L == 1
            handles.Limit = Main_handles.Limit;
        end
        
        set(handles.(['L',num2str(L), '_Illum']),'String', Main_handles.Display.AllIllum)
        
        set(handles.(['LLim',num2str(L)]), 'String', num2str( handles.Limit.LLim{L}))
        set(handles.(['HLim',num2str(L)]), 'String', num2str( handles.Limit.HLim{L}))
        set(handles.(['L',num2str(L), '_Illum']), 'String', handles.Limit.Illum{L})
        set(handles.(['L',num2str(L), '_Obj']), 'String', handles.Limit.Object{L})
        set(handles.(['L',num2str(L), '_Meas']), 'String', handles.Limit.Meas{L})
        set(handles.(['L',num2str(L), '_Prop']), 'String', handles.Limit.Prop{L})
    else
        set(handles.(['L',num2str(L), '_Illum']),'String', Main_handles.Display.AllIllum)
        handles.Limit.LLim{L} = -Inf;
        handles.Limit.HLim{L} = +Inf;
    end
end


% set(handles.L1_Illum,'String', Main_handles.Display.AllIllum)
% handles.Limit.LLim{1} = -Inf;
% handles.Limit.HLim1{1} = +Inf;
%
% if isfield(Main_handles, 'Limit')
%     handles.Limit = Main_handles.Limit;
%     set(handles.L1_Illum,'String', Main_handles.Display.AllIllum)
%
%     set(handles.LLim1, 'String', num2str( handles.Limit.LLim{1}))
%     set(handles.HLim1, 'String', num2str( handles.Limit.HLim{1}))
%     set(handles.L1_Illum, 'String', handles.Limit.Illum{1})
%     set(handles.L1_Obj, 'String', handles.Limit.Object{1})
%     set(handles.L1_Meas, 'String', handles.Limit.Meas{1})
%     set(handles.L1_Prop, 'String', handles.Limit.Prop{1})
% end

clear Main_handles
% Update handles structure
guidata(hObject, handles);

% UIWAIT makes LimitPrefs wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = LimitPrefs_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;




%%%%%%%%%%%%%%%%%%%%%%%%%  Limits 1  %%%%%%%%%%%%%%%%%%%%%%%%%





% --- Executes on selection change in L1_Illum.
function L1_Illum_Callback(hObject, eventdata, handles)
% hObject    handle to L1_Illum (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

IllumList = cellstr(get(hObject,'String'));
SelectedIllumNum = get(hObject,'Value');

handles.Limit.Illum{1} = IllumList{SelectedIllumNum};

%Set the Object pop-up
set(handles.L1_Obj,'String', fieldnames(handles.Export.(handles.Display.SelectedCond{1}).(handles.Limit.Illum{1})))

% Update handles structure
guidata(hObject, handles);



% --- Executes on selection change in L1_Obj.
function L1_Obj_Callback(hObject, eventdata, handles)
% hObject    handle to L1_Obj (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%Get selected object
ObjList = cellstr(get(hObject,'String'));
SelectedObjNum = get(hObject,'Value');
handles.Limit.Object{1} = ObjList{SelectedObjNum};

%Set the Measurement pop-up
set(handles.L1_Meas,'String', fieldnames(handles.Export.(handles.Display.SelectedCond{1}).(handles.Limit.Illum{1}).(handles.Limit.Object{1})))

% Update handles structure
guidata(hObject, handles);



% --- Executes on selection change in L1_Meas.
function L1_Meas_Callback(hObject, eventdata, handles)
% hObject    handle to L1_Meas (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%Get selected Measurement
MeasList = cellstr(get(hObject,'String'));
SelectedMeasNum = get(hObject,'Value');

handles.Limit.Meas{1} = MeasList{SelectedMeasNum};

set(handles.L1_Prop,'String',handles.Limit.Properties)
set(handles.L1_Prop,'Value', 1)
handles.Limit.Prop{1} = 'Mean';

% Update handles structure
guidata(hObject, handles);


% --- Executes on selection change in L1_Prop.
function L1_Prop_Callback(hObject, eventdata, handles)
% hObject    handle to L1_Prop (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%Get selected Measurement
PropList = cellstr(get(hObject,'String'));
SelectedPropNum = get(hObject,'Value');

handles.Limit.Prop{1} = PropList{SelectedPropNum};
% Update handles structure
guidata(hObject, handles);


function LLim1_Callback(hObject, eventdata, handles)
% hObject    handle to LLim1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


handles.Limit.LLim{1} = str2double(get(hObject,'String'));
% Update handles structure
guidata(hObject, handles);



function HLim1_Callback(hObject, eventdata, handles)
% hObject    handle to HLim1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

handles.Limit.HLim{1} = str2double(get(hObject,'String'));
% Update handles structure
guidata(hObject, handles);

%%

%%%%%%%%%%%%%%%%%%%%%%%  LIMIT 2  %%%%%%%%%%%%%%%%%%%%%%%%%%%



% --- Executes on selection change in L1_Illum.
function L2_Illum_Callback(hObject, eventdata, handles)
% hObject    handle to L2_Illum (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

IllumList = cellstr(get(hObject,'String'));
SelectedIllumNum = get(hObject,'Value');

handles.Limit.Illum{2} = IllumList{SelectedIllumNum};

%Set the Object pop-up
set(handles.L2_Obj,'String', fieldnames(handles.Export.(handles.Display.SelectedCond{1}).(handles.Limit.Illum{2})))

% Update handles structure
guidata(hObject, handles);



% --- Executes on selection change in L2_Obj.
function L2_Obj_Callback(hObject, eventdata, handles)
% hObject    handle to L2_Obj (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%Get selected object
ObjList = cellstr(get(hObject,'String'));
SelectedObjNum = get(hObject,'Value');
handles.Limit.Object{2} = ObjList{SelectedObjNum};

%Set the Measurement pop-up
set(handles.L2_Meas,'String', fieldnames(handles.Export.(handles.Display.SelectedCond{1}).(handles.Limit.Illum{2}).(handles.Limit.Object{2})))

% Update handles structure
guidata(hObject, handles);



% --- Executes on selection change in L2_Meas.
function L2_Meas_Callback(hObject, eventdata, handles)
% hObject    handle to L2_Meas (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%Get selected Measurement
MeasList = cellstr(get(hObject,'String'));
SelectedMeasNum = get(hObject,'Value');

handles.Limit.Meas{2} = MeasList{SelectedMeasNum};

set(handles.L2_Prop,'String',handles.Limit.Properties)
set(handles.L2_Prop,'Value', 1)
handles.Limit.Prop{2} = 'Mean';

% Update handles structure
guidata(hObject, handles);


% --- Executes on selection change in L2_Prop.
function L2_Prop_Callback(hObject, eventdata, handles)
% hObject    handle to L2_Prop (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%Get selected Measurement
PropList = cellstr(get(hObject,'String'));
SelectedPropNum = get(hObject,'Value');

handles.Limit.Prop{2} = PropList{SelectedPropNum};
% Update handles structure
guidata(hObject, handles);


function LLim2_Callback(hObject, eventdata, handles)
% hObject    handle to LLim1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


handles.Limit.LLim{2} = str2double(get(hObject,'String'));
% Update handles structure
guidata(hObject, handles);



function HLim2_Callback(hObject, eventdata, handles)
% hObject    handle to HLim1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

handles.Limit.HLim{2} = str2double(get(hObject,'String'));
% Update handles structure
guidata(hObject, handles);

%%

%%%%%%%%%%%%%%%%%%%%%%%  LIMIT 3  %%%%%%%%%%%%%%%%%%%%%%%%%%%



% --- Executes on selection change in L3_Illum.
function L3_Illum_Callback(hObject, eventdata, handles)
% hObject    handle to L3_Illum (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

IllumList = cellstr(get(hObject,'String'));
SelectedIllumNum = get(hObject,'Value');

handles.Limit.Illum{3} = IllumList{SelectedIllumNum};

%Set the Object pop-up
set(handles.L3_Obj,'String', fieldnames(handles.Export.(handles.Display.SelectedCond{1}).(handles.Limit.Illum{3})))

% Update handles structure
guidata(hObject, handles);



% --- Executes on selection change in L3_Obj.
function L3_Obj_Callback(hObject, eventdata, handles)
% hObject    handle to L3_Obj (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%Get selected object
ObjList = cellstr(get(hObject,'String'));
SelectedObjNum = get(hObject,'Value');
handles.Limit.Object{3} = ObjList{SelectedObjNum};

%Set the Measurement pop-up
set(handles.L3_Meas,'String', fieldnames(handles.Export.(handles.Display.SelectedCond{1}).(handles.Limit.Illum{3}).(handles.Limit.Object{3})))

% Update handles structure
guidata(hObject, handles);



% --- Executes on selection change in L3_Meas.
function L3_Meas_Callback(hObject, eventdata, handles)
% hObject    handle to L3_Meas (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%Get selected Measurement
MeasList = cellstr(get(hObject,'String'));
SelectedMeasNum = get(hObject,'Value');

handles.Limit.Meas{3} = MeasList{SelectedMeasNum};

set(handles.L3_Prop,'String',handles.Limit.Properties)
set(handles.L3_Prop,'Value', 1)
handles.Limit.Prop{3} = 'Mean';

% Update handles structure
guidata(hObject, handles);


% --- Executes on selection change in L3_Prop.
function L3_Prop_Callback(hObject, eventdata, handles)
% hObject    handle to L3_Prop (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%Get selected Measurement
PropList = cellstr(get(hObject,'String'));
SelectedPropNum = get(hObject,'Value');

handles.Limit.Prop{3} = PropList{SelectedPropNum};
% Update handles structure
guidata(hObject, handles);


function LLim3_Callback(hObject, eventdata, handles)
% hObject    handle to LLim1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


handles.Limit.LLim{3} = str2double(get(hObject,'String'));
% Update handles structure
guidata(hObject, handles);



function HLim3_Callback(hObject, eventdata, handles)
% hObject    handle to HLim1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

handles.Limit.HLim{3} = str2double(get(hObject,'String'));
% Update handles structure
guidata(hObject, handles);


%%

%%%%%%%%%%%%%%%%%%%%%%%  LIMIT 4  %%%%%%%%%%%%%%%%%%%%%%%%%%%



% --- Executes on selection change in L4_Illum.
function L4_Illum_Callback(hObject, eventdata, handles)
% hObject    handle to L4_Illum (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

IllumList = cellstr(get(hObject,'String'));
SelectedIllumNum = get(hObject,'Value');

handles.Limit.Illum{4} = IllumList{SelectedIllumNum};

%Set the Object pop-up
set(handles.L4_Obj,'String', fieldnames(handles.Export.(handles.Display.SelectedCond{1}).(handles.Limit.Illum{4})))

% Update handles structure
guidata(hObject, handles);



% --- Executes on selection change in L4_Obj.
function L4_Obj_Callback(hObject, eventdata, handles)
% hObject    handle to L4_Obj (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%Get selected object
ObjList = cellstr(get(hObject,'String'));
SelectedObjNum = get(hObject,'Value');
handles.Limit.Object{4} = ObjList{SelectedObjNum};

%Set the Measurement pop-up
set(handles.L4_Meas,'String', fieldnames(handles.Export.(handles.Display.SelectedCond{1}).(handles.Limit.Illum{4}).(handles.Limit.Object{4})))

% Update handles structure
guidata(hObject, handles);



% --- Executes on selection change in L4_Meas.
function L4_Meas_Callback(hObject, eventdata, handles)
% hObject    handle to L4_Meas (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%Get selected Measurement
MeasList = cellstr(get(hObject,'String'));
SelectedMeasNum = get(hObject,'Value');

handles.Limit.Meas{4} = MeasList{SelectedMeasNum};

set(handles.L4_Prop,'String',handles.Limit.Properties)
set(handles.L4_Prop,'Value', 1)
handles.Limit.Prop{4} = 'Mean';

% Update handles structure
guidata(hObject, handles);


% --- Executes on selection change in L4_Prop.
function L4_Prop_Callback(hObject, eventdata, handles)
% hObject    handle to L4_Prop (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%Get selected Measurement
PropList = cellstr(get(hObject,'String'));
SelectedPropNum = get(hObject,'Value');

handles.Limit.Prop{4} = PropList{SelectedPropNum};
% Update handles structure
guidata(hObject, handles);


function LLim4_Callback(hObject, eventdata, handles)
% hObject    handle to LLim1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


handles.Limit.LLim{4} = str2double(get(hObject,'String'));
% Update handles structure
guidata(hObject, handles);



function HLim4_Callback(hObject, eventdata, handles)
% hObject    handle to HLim1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

handles.Limit.HLim{4} = str2double(get(hObject,'String'));
% Update handles structure
guidata(hObject, handles);
%%

%%

%%%%%%%%%%%%%%%%%%%%%%%  LIMIT 5  %%%%%%%%%%%%%%%%%%%%%%%%%%%



% --- Executes on selection change in L5_Illum.
function L5_Illum_Callback(hObject, eventdata, handles)
% hObject    handle to L5_Illum (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

IllumList = cellstr(get(hObject,'String'));
SelectedIllumNum = get(hObject,'Value');

handles.Limit.Illum{5} = IllumList{SelectedIllumNum};

%Set the Object pop-up
set(handles.L5_Obj,'String', fieldnames(handles.Export.(handles.Display.SelectedCond{1}).(handles.Limit.Illum{5})))

% Update handles structure
guidata(hObject, handles);



% --- Executes on selection change in L5_Obj.
function L5_Obj_Callback(hObject, eventdata, handles)
% hObject    handle to L5_Obj (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%Get selected object
ObjList = cellstr(get(hObject,'String'));
SelectedObjNum = get(hObject,'Value');
handles.Limit.Object{5} = ObjList{SelectedObjNum};

%Set the Measurement pop-up
set(handles.L5_Meas,'String', fieldnames(handles.Export.(handles.Display.SelectedCond{1}).(handles.Limit.Illum{5}).(handles.Limit.Object{5})))

% Update handles structure
guidata(hObject, handles);



% --- Executes on selection change in L5_Meas.
function L5_Meas_Callback(hObject, eventdata, handles)
% hObject    handle to L5_Meas (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%Get selected Measurement
MeasList = cellstr(get(hObject,'String'));
SelectedMeasNum = get(hObject,'Value');

handles.Limit.Meas{5} = MeasList{SelectedMeasNum};

set(handles.L5_Prop,'String',handles.Limit.Properties)
set(handles.L5_Prop,'Value', 1)
handles.Limit.Prop{5} = 'Mean';

% Update handles structure
guidata(hObject, handles);


% --- Executes on selection change in L5_Prop.
function L5_Prop_Callback(hObject, eventdata, handles)
% hObject    handle to L5_Prop (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%Get selected Measurement
PropList = cellstr(get(hObject,'String'));
SelectedPropNum = get(hObject,'Value');

handles.Limit.Prop{5} = PropList{SelectedPropNum};
% Update handles structure
guidata(hObject, handles);


function LLim5_Callback(hObject, eventdata, handles)
% hObject    handle to LLim1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


handles.Limit.LLim{5} = str2double(get(hObject,'String'));
% Update handles structure
guidata(hObject, handles);



function HLim5_Callback(hObject, eventdata, handles)
% hObject    handle to HLim1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

handles.Limit.HLim{5} = str2double(get(hObject,'String'));
% Update handles structure
guidata(hObject, handles);


%%
%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%% Apply limits %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% --- Executes on button press in Filter.
function Filter_Callback(hObject, eventdata, handles)
% hObject    handle to Filter (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
try
    close(findobj('Tag', 'LimDisplay'))
catch
end
%Generate modified string from conditions
for E = 1:length(handles.Display.SelectedCond)
    handles.Display.CondStr{E} = regexprep(handles.Display.SelectedCond{E}, '_', ' ');
    handles.Display.CondStr{E} = regexprep(handles.Display.CondStr{E}, 'p', '.');
end


for E = 1:length(handles.Display.SelectedCond)
    
    
    CheckLabel = handles.Export.(handles.Display.SelectedCond{E}).(handles.Limit.Illum{1}).(handles.Limit.Object{1}).CheckLabel.Cells;
    NumAllCells{E} = size(CheckLabel,2);
    ValidCells{E} = find(min(CheckLabel));
    NumValidCells{E} = length(ValidCells{E});
    for L = 1:length(handles.Limit.Meas)
        CellTraces = handles.Export.(handles.Display.SelectedCond{E}).(handles.Limit.Illum{L}).(handles.Limit.Object{L}).(handles.Limit.Meas{L}).Cells(:,ValidCells{E});
        T0Ind = handles.Export.(handles.Display.SelectedCond{E}).Experiment.TimeZero;
        if T0Ind <3
            T0Imd = 3;
        end
        %{'Mean';  'Basal'; 'Final';'MaxDiff'};
        switch(handles.Limit.Prop{L})
            case 'Mean'
                CellsProp = mean(CellTraces);
            case 'Median'
                CellsProp = median(CellTraces);
            case 'Basal'
                CellsProp = mean(CellTraces(1:T0,:));
            case 'Final'
                CellsProp = mean(CellTraces(end-3:end,:));
            case 'MaxDiff'
                CellsProp = max(CellTraces) - mean(CellTraces(1:T0,:));
        end
        
        %FilteredCells{L} = intersect(find(MeanVal>handles.Limit.LLim{L}) ,
        %find(MeanVal<handles.Limit.HLim{L}));
        FilteredCells{E,L} = find(CellsProp>handles.Limit.LLim{L} & CellsProp<handles.Limit.HLim{L});
        
        %Display scatter plot of single trace measurement
        Xval = E + randn(1,NumValidCells{E})./20;
        figure(20+L)
        set(20+L,'Tag', 'LimDisplay')
        hold all
        plot(Xval, CellsProp, 'or');
        plot(Xval(FilteredCells{E,L}), CellsProp(FilteredCells{E,L}), 'og');
        hold off
        
        CondLegend{E} = [handles.Display.CondStr{E}, ' (', num2str(NumValidCells{E}), ')'];
        
        if E==length(handles.Display.SelectedCond)
            ylabel([handles.Limit.Illum{L}, ' ', handles.Limit.Object{L}, ' ', handles.Limit.Meas{L},], 'FontSize', 12)
            set(gca, 'FontSize', 12, 'LineWidth', 1, 'box', 'on')
            set(gca, 'XTick',[1:E],  'XTickLabel', handles.Display.CondStr)
            legend(CondLegend)
        end
        
    end
end
for E = 1:length(handles.Display.SelectedCond)
    KeptCells{E} = ValidCells{E}(FilteredCells{E,1});
    if size(FilteredCells,2) >1
        for L = 2:size(FilteredCells,2)
            KeptCells{E} = intersect(KeptCells{E}, ValidCells{E}(FilteredCells{E,L}));
        end
    end
end


SummaryTxt = [];
for E = 1:length(handles.Display.SelectedCond)
    SummaryTxt{E} = [handles.Display.CondStr{E}, ': All: ', num2str(NumAllCells{E}), ' Valid: ', num2str(NumValidCells{E})];
    for L = 1:length(handles.Limit.Meas)
        SummaryTxt{E} = [SummaryTxt{E}, ' Lim ', num2str(L), ':' ,num2str(length(FilteredCells{E,L}))];
    end
    SummaryTxt{E} = [SummaryTxt{E}, ' Kept: ',num2str(length(KeptCells{E}))];
end

set(handles.OutTxt, 'String', SummaryTxt)

handles.Limit.FilteredCells = FilteredCells;
handles.Limit.ValidCells = ValidCells;
handles.Limit.KeptCells = KeptCells;




% Update handles structure
guidata(hObject, handles);



% --- Executes when user attempts to close figure1.
function figure1_CloseRequestFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

try
    close(findobj('Tag', 'LimDisplay'))
catch
end


GUI_handle = findobj('Name','Export2Meas');
Main_handles = guidata(GUI_handle);
if isfield(handles.Limit, 'KeptCells')
    set(Main_handles.ActiveLimit,'Value', 1);
    Main_handles.Limit =  handles.Limit;
    guidata(GUI_handle, Main_handles);
end


% Hint: delete(hObject) closes the figure
delete(hObject);



function OutTxt_Callback(hObject, eventdata, handles)
% hObject    handle to OutTxt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of OutTxt as text
%        str2double(get(hObject,'String')) returns contents of OutTxt as a double


% --- Executes during object creation, after setting all properties.
function OutTxt_CreateFcn(hObject, eventdata, handles)
% hObject    handle to OutTxt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% --- Executes on button press in ClearLim.
function ClearLim_Callback(hObject, eventdata, handles)
% hObject    handle to ClearLim (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

L = length(handles.Limit.Meas)

handles.Limit.LLim{L} = -Inf;
set(handles.(['LLim',num2str(L)]), 'String', '-Inf')
handles.Limit.HLim{L} = +Inf;
set(handles.(['HLim',num2str(L)]), 'String', '+Inf')
set(handles.(['L',num2str(L), '_Illum']),'String', handles.Display.AllIllum)
set(handles.(['L',num2str(L), '_Illum']),'Value', 1)


set(handles.(['L',num2str(L), '_Obj']),'String', 'Object')
set(handles.(['L',num2str(L), '_Obj']),'Value', 1)


set(handles.(['L',num2str(L), '_Meas']),'String', 'Measurement')
set(handles.(['L',num2str(L), '_Meas']),'Value', 1)


set(handles.(['L',num2str(L), '_Prop']),'String', 'Property')
set(handles.(['L',num2str(L), '_Prop']),'Value', 1)

if L > 1
    handles.Limit.Illum = handles.Limit.Illum(1:L-1);
    handles.Limit.Object = handles.Limit.Object(1:L-1);
    handles.Limit.Meas = handles.Limit.Meas(1:L-1);
    handles.Limit.Prop = handles.Limit.Prop(1:L-1);
else
    handles.Limit = rmfield(handles.Limit, {'Illum','Object', 'Meas', 'Prop','KeptCells'});
    
end


% Update handles structure
guidata(hObject, handles);
