function [Var] = ReadImgParameters(Var)
%% Access to Image folder and record image file paths for every timepoint and illumination

%% Go to Img folder and find files
%Save current dir as base directory
BaseDir = cd;
%Get Folder name from Experiment structure
ImgFolder = Var.Experiment.Folder;
ImgFolderTxt = regexprep(ImgFolder, '\', '\\\\');
cd(ImgFolder)

%get Image name
ImgName = Var.Experiment.Filename;

%set extension based  software and acquisition type

if  strcmp(Var.Experiment.Software, 'MetaMorph')
    if strcmp(Var.Experiment.AcquisitionType, 'IterSave') || strcmp(Var.Experiment.AcquisitionType, 'SingleStack')
        Extension = '*stk';
        SearchString = [ImgName, Extension];
    elseif strcmp(Var.Experiment.AcquisitionType, 'MultiDimensional')
        Extension = '*TIF';
        SearchString = [ImgName, Extension];
    end
elseif strcmp(Var.Experiment.Software, 'MicroManager')
    if strcmp(Var.Experiment.AcquisitionType, 'MultiDimensional') || strcmp(Var.Experiment.AcquisitionType, 'MultiDimScript')
        SearchString = [ImgName, '*tif'];
        TifFiles = dir(SearchString);
        
        if ~isempty(TifFiles)
            PositionFolderName = [];
        else
            PositionDir = dir(ImgFolder);
            
            %assignin('base', 'Pdir', PositionDir)
            
            NumPos = 0;
            for P = 1:length(PositionDir)
                
                PosStr = strfind(PositionDir(P).name, 'Pos');
                
                if PositionDir(P).isdir && ~isempty(PosStr) && PosStr == 1
                    
                    PosNumStr = [];
                    PosStr = PosStr+3;
                    % PD = PositionDir(P).name
                    %Dig = isstrprop(PositionDir(P).name(PosStr), 'digit')
                    while PosStr<= length(PositionDir(P).name) && isstrprop(PositionDir(P).name(PosStr), 'digit');
                        PosNumStr = [PosNumStr,PositionDir(P).name(PosStr)];
                        PosStr = PosStr+1;
                    end
                    %PosFolderNum = str2double(PositionDir(P).name(NumLoc==1));
                    PosFolderNum = str2double(PosNumStr);
                    %check for the first folder if the Pos numbering start from 0 or 1
                    if NumPos == 0
                        if PosFolderNum == 0
                            AddOne = 1;
                            NumPos = 1;
                        else
                            AddOne = 0;
                            NumPos = 1;
                        end
                    end
                    
                    if Var.Analysis.CurrentPos == PosFolderNum+AddOne  %+1 if pos number start with 0
                        SearchString = [PositionDir(P).name, filesep, ImgName, '*tif'];
                        PositionFolderName = PositionDir(P).name;
                        NumPos = NumPos+1;
                        %                                     CP = Var.Analysis.CurrentPos
                        %                 PosF = PosFolderNum+AddOne
                    end
                end
            end
        end
        %Check file list for lowest timepoint saved
        if strcmp(Var.Experiment.AcquisitionType, 'MultiDimScript')
            ImgFiles = dir(SearchString);
            for f = 1:length(ImgFiles)
                FileName = ImgFiles(f).name;
                %dissect filename to extract illumination and Time point
                US_T = strfind(FileName, '_T');
                TimePoint = str2double(FileName(US_T(end)+2:US_T(end)+4));
                AllT(f) = double(TimePoint);
            end
            %Set lowest time point to FirstTpoint
            Var.Analysis.FirstTPoint = min(AllT);
        end
    end
    
elseif  strcmp(Var.Experiment.Software, 'NikonElement') && (strcmp(Var.Experiment.AcquisitionType, 'TiffSerie') || strcmp(Var.Experiment.AcquisitionType, 'TiffExport'))
    Extension = '*tif';
    SearchString = [ImgName, Extension];
elseif  strcmp(Var.Experiment.Software, 'OpenLab') && strcmp(Var.Experiment.AcquisitionType, 'SingleStack')
    Extension = '*tif';
    SearchString = [ImgName, Extension];
    
elseif  strcmp(Var.Experiment.Software, 'TIF') && strcmp(Var.Experiment.AcquisitionType, 'SingleStack')
    Extension = '*tif';
    SearchString = [ImgName, Extension];
end

% Find files with matching initial string in ImgFolder
ImgFiles = dir(SearchString);

%if no file is found
if isempty(ImgFiles)
    error(['No files found looking for ' SearchString ' in ' ImgFolderTxt])
end

cd(BaseDir)

assignin('base', 'ImgFiles', ImgFiles)

%% Distrubute files for Image analysis
NbFiles = size(ImgFiles,1);
NumPos = Var.Analysis.NumPos;
Var.Analysis.NumIllum = length(Var.Experiment.Illumination);
NumIllum = Var.Analysis.NumIllum;


% get files depending on different software and acquisition types
if  strcmp(Var.Experiment.Software, 'MetaMorph') && strcmp(Var.Experiment.AcquisitionType, 'SingleStack')
    % For single stack one should have a single image file
    if length(ImgFiles) > 1
        error(['Multiple files found with ' SearchString ' in ' ImgFolderTxt])
    end
    %Generate full filepath
    Var.Analysis.FilePath{1} = fullfile(ImgFolder, ImgFiles.name);
    %Generate path for saving analysis
    Dot = strfind(ImgFiles.name, '.');
    Var.Analysis.OutPath = [fullfile(ImgFolder, ImgFiles.name(1:Dot-1)), '_Pos', num2str(Var.Analysis.CurrentPos,'%02d')];
    
    %Try to read images
    [stack, img_read] = tiffread_serge(Var.Analysis.FilePath{1}, 0);
    Var.Analysis.NumFrame = img_read/(NumPos*NumIllum);
    
    
elseif  strcmp(Var.Experiment.Software, 'MetaMorph') && strcmp(Var.Experiment.AcquisitionType, 'IterSave')
    %For IterSave multiple file will have the same root Use first one for as
    %basename but remove number
    US  = strfind(ImgFiles(1).name,'_');
    for i = 1:NbFiles
        %Generate full filepath
        Var.Analysis.FilePath{i} = fullfile(ImgFolder, [ImgFiles(1).name(1:US(end)), num2str(i), '.stk']);
    end
    %Generate path for saving analysis
    Var.Analysis.OutPath = [fullfile(ImgFolder, ImgFiles(1).name(1:US(end)-1)), '_Pos', num2str(Var.Analysis.CurrentPos,'%02d')];
    %Get Number of frames for number of files found
    Var.Analysis.NumFrame = NbFiles;
    
elseif  strcmp(Var.Experiment.Software, 'MetaMorph') && strcmp(Var.Experiment.AcquisitionType, 'MultiDimensional')
    AllPos = [];
    NbFilesAnalysis = 0;
    for f = 1:NbFiles
        %Get Filename
        FileName = ImgFiles(f).name;
        %dissect filename to extract Position, illumination, Time point
        US = strfind(FileName, '_');
        Dot = strfind(FileName, '.');
        TimePoint = str2double(FileName(US(end)+2:Dot(end)-1));
        Position = str2double(FileName(US(end-1)+2:US(end)-1));
        Illum = FileName(US(end-2)+1:US(end-1)-1);
        
        %Check if file position matches current position
        if Var.Analysis.CurrentPos == Position
            for I = 1:NumIllum
                if strfind(Illum, Var.Experiment.Filter{I})
                    T = double(TimePoint);
                    Var.Analysis.FilePath{I,T} = fullfile(ImgFolder, ImgFiles(f).name);
                    Var.Analysis.OutPath = [fullfile(ImgFolder, ImgFiles(f).name(1:US(end-2)-1)), '_Pos', num2str(Var.Analysis.CurrentPos,'%02d')];
                    NbFilesAnalysis = NbFilesAnalysis +1;
                end
            end
        end
        %if not all positions are present for analysis
        AllPos = [AllPos, Position];
        
        
        
    end
    %Remove duplicated position numbers from AllPos
    Var.Analysis.AllPos = unique(AllPos);
    
    %Get true number of positions in folder
    NumPos = length(Var.Analysis.AllPos);
    
    %get number of frames from MD data
    Var.Analysis.NumFrame = NbFilesAnalysis/(NumPos*NumIllum);
elseif  strcmp(Var.Experiment.Software, 'MicroManager') && strcmp(Var.Experiment.AcquisitionType, 'MultiDimensional')
    NbFilesAnalysis = 0;
    for f = 1:NbFiles
        %Get Filename
        FileName = ImgFiles(f).name;
        %dissect filename to extract illumination and Time point
        US = strfind(FileName, '_');
        TimePoint = str2double(FileName(US(1)+1:US(2)-1))+1;
        
        Illum = FileName(US(2)+3:US(end));
        
        %Check if file position matches current position
        
        for I = 1:NumIllum
            if strfind(Illum, Var.Experiment.Filter{I})
                T = double(TimePoint);
                Var.Analysis.FilePath{I,T} = fullfile(ImgFolder, PositionFolderName, ImgFiles(f).name);
                Var.Analysis.OutPath = [fullfile(ImgFolder, ImgFiles(f).name(1:US(end-2)-1)), '_Pos', num2str(Var.Analysis.CurrentPos,'%02d')];
                NbFilesAnalysis = NbFilesAnalysis +1;
            end
        end
        
    end
    
    %get number of frames from MD data
    Var.Analysis.NumFrame = NbFilesAnalysis/NumIllum;
    
    %verify with size FilePath Cell
    NumFilePath = size( Var.Analysis.FilePath,2);
    
    if Var.Analysis.NumFrame ~= NumFilePath
        WarnStr = ['Mismatch between Number of frame calculated: ', num2str(Var.Analysis.NumFrame), ...
            ' and Number of files in FilePath matrix: ',num2str(NumFilePath)];
        warning(WarnStr)
        
        Var.Analysis.NumFrame = NumFilePath;
    end
    
    
elseif  strcmp(Var.Experiment.Software, 'MicroManager') && strcmp(Var.Experiment.AcquisitionType, 'MultiDimScript')
    NbFilesAnalysis = 0;
    for f = 1:NbFiles
        %Get Filename
        FileName = ImgFiles(f).name;
        %dissect filename to extract illumination and Time point
        US_T = strfind(FileName, '_T');
        TimePoint = str2double(FileName(US_T(end)+2:US_T(end)+4));
        IllumStart = length(ImgName)+2;
        Illum = FileName(IllumStart:US_T(end)-1);
        
        %Check if file position matches current position
        
        for I = 1:NumIllum
            if strfind(Illum, Var.Experiment.Filter{I})
                T = double(TimePoint) -(Var.Analysis.FirstTPoint)+1;
                Var.Analysis.FilePath{I,T} = fullfile(ImgFolder, PositionFolderName, ImgFiles(f).name);
                Var.Analysis.OutPath = [fullfile(ImgFolder, ImgName), '_Pos', num2str(Var.Analysis.CurrentPos,'%02d')];
                NbFilesAnalysis = NbFilesAnalysis +1;
            end
        end
        
    end
    
    %get number of frames from MD data
    Var.Analysis.NumFrame = NbFilesAnalysis/NumIllum;
    
elseif  strcmp(Var.Experiment.Software, 'NikonElement') && strcmp(Var.Experiment.AcquisitionType, 'TiffSerie')
    
    for f = 1:NbFiles
        %Get Filename
        FileName = ImgFiles(f).name;
        %dissect filename to extract Position, illumination, Time point
        T = strfind(FileName, 'timet');
        Dot = strfind(FileName, '.');
        TimePoint = str2double(FileName(T(end)+6:Dot(end)-1));
        
        
        T = double(TimePoint);
        Var.Analysis.FilePath{1,T} = fullfile(ImgFolder, ImgFiles(f).name);
        Var.Analysis.OutPath = [fullfile(ImgFolder, ImgFiles(f).name(1:T(end)-1)), '_Pos', num2str(Var.Analysis.CurrentPos,'%02d')];
    end
    
    %get number of frames from data
    Var.Analysis.NumFrame = NbFiles;
    
    
elseif  strcmp(Var.Experiment.Software, 'NikonElement') && strcmp(Var.Experiment.AcquisitionType, 'TiffExport')
    AllPos = [];
    for f = 1:NbFiles
        %Get Filename
        FileName = ImgFiles(f).name;
        %dissect filename to extract Position, illumination, Time point
        US = strfind(FileName, '_p');
        t0 = strfind(FileName, 't0');
        Dot = strfind(FileName, '.');
        
        Position = str2double(FileName(US(end)+2:US(end)+3));
        
        TimePoint = str2double(FileName(t0+1:t0+5));
        
        Illum = FileName(Dot(end)-3:Dot(end)-1);
        
        %Check if file position matches current position
        if Var.Analysis.CurrentPos == Position
            for I = 1:NumIllum
                if strfind(Illum, Var.Experiment.Filter{I})
                    T = double(TimePoint);
                    Var.Analysis.FilePath{I,T} = fullfile(ImgFolder, ImgFiles(f).name);
                    Var.Analysis.OutPath = [fullfile(ImgFolder, ImgFiles(f).name(1:US(end)-1)), '_Pos', num2str(Var.Analysis.CurrentPos,'%02d')];
                end
            end
        end
        %if not all positions are present for analysis
        AllPos = [AllPos, Position];
        
        
        
    end
    %Remove duplicated position numbers from AllPos
    Var.Analysis.AllPos = unique(AllPos);
    
    %Get true number of positions in folder
    NumPos = length(Var.Analysis.AllPos);
    
    %get number of frames from MD data
    Var.Analysis.NumFrame = NbFiles/(NumPos*NumIllum);
elseif  strcmp(Var.Experiment.Software, 'TIF') && strcmp(Var.Experiment.AcquisitionType, 'SingleStack')
    % For single stack one should have a single image file
    if length(ImgFiles) > 1
        error(['Multiple files found with ' SearchString ' in ' ImgFolderTxt])
    end
    %Generate full filepath
    Var.Analysis.FilePath{1} = fullfile(ImgFolder, ImgFiles.name);
    %Generate path for saving analysis
    Dot = strfind(ImgFiles.name, '.');
    Var.Analysis.OutPath = [fullfile(ImgFolder, ImgFiles.name(1:Dot-1)), '_Pos', num2str(Var.Analysis.CurrentPos,'%02d')];
    
    %Try to read images
    [stack, img_read] = tiffread_serge(Var.Analysis.FilePath{1}, 0);
    Var.Analysis.NumFrame = img_read/(NumPos*NumIllum);
    
elseif  strcmp(Var.Experiment.Software, 'OpenLab') && strcmp(Var.Experiment.AcquisitionType, 'SingleStack')
    % For single stack one should have a single image file
    if length(ImgFiles) > 1
        error(['Multiple files found with ' SearchString ' in ' ImgFolderTxt])
    end
    NbFilesAnalysis = 1;
    %Generate full filepath
    Var.Analysis.FilePath{1} = fullfile(ImgFolder, ImgFiles.name);
    %Generate path for saving analysis
    Dot = strfind(ImgFiles.name, '.');
    Var.Analysis.OutPath = [fullfile(ImgFolder, ImgFiles.name(1:Dot-1)), '_Pos', num2str(Var.Analysis.CurrentPos,'%02d')];
    
    %Try to read images
    [stack, img_read] = tiffread_serge(Var.Analysis.FilePath{1}, 0);
    Var.Analysis.NumFrame = img_read/(NumPos*NumIllum);
    
end



%% Output number files found and number illumination and number of frame
if Var.Analysis.CurrentPos == NumPos
    ResultStr  = [num2str(NbFilesAnalysis), ' Files named ', SearchString ' found in: ', ImgFolderTxt, ' reprensenting:\n' num2str(NumPos) ' Positions ', num2str(NumIllum), ' Exposure types and ' , num2str(Var.Analysis.NumFrame), ' Frames\n\n'];
    fprintf(ResultStr)
end


