function XLSFileName = Export2Excell(ExportFiles)
warning('off', 'MATLAB:xlswrite:AddSheet');
%% Load Export File
load(ExportFiles)

%Create xls file
XLSFileName = [ExportFiles(1:end-4), '.xls'];
xlswrite(XLSFileName, 1, 'Legend');

%% loop through fields from export structure
iter = 0;
%Conditions
Conditions = fieldnames(Export);
for C = 1:length(Conditions)
    %illuminations
    Illum = fieldnames(Export.(Conditions{C}));
    for I = 1:length(Illum)
        %exclude time and experiment description
        if strcmp(Illum{I}, 'Time')
            %Save to Time toexcell sheet
            SheetName = [Conditions{C}, '_',Illum{I}];
            Data = Export.(Conditions{C}).(Illum{I})';
            xlswrite(XLSFileName, Data, SheetName);
        elseif strcmp(Illum{I}, 'Experiment')
            % need to wirte something smart to export these info
        else
            %Get all objects
            Objects = fieldnames(Export.(Conditions{C}).(Illum{I}));
            for O = 1:length(Objects)
            	iter = iter+1;
            	SheetLegend{1,1} = C;
            	SheetLegend{1,2} = Conditions{C};
            	SheetLegend{1,3} = I;
            	SheetLegend{1,4} = Illum{I};
            	SheetLegend{1,5} = O;
            	SheetLegend{1,6} = Objects{O};
            	xlswrite(XLSFileName, SheetLegend, 'Legend',['A',num2str(iter)]);
                %Get all measurements
            	Meas = fieldnames(Export.(Conditions{C}).(Illum{I}).(Objects{O}));
                for M = 1:length(Meas)
                    %Save to excell sheet
                    
                    SheetName = [num2str(C), '_',num2str(I), '_',num2str(O), '_',Meas{M}];
                    Data = Export.(Conditions{C}).(Illum{I}).(Objects{O}).(Meas{M}).Cells;
                    xlswrite(XLSFileName, Data, SheetName);
                end
            end
        end
    end
end

warning('on', 'MATLAB:xlswrite:AddSheet');

    