function Var = DisplayMeasurements(Var, CallNum)

if nargin == 1
    CallNum = 1;
end
%Get object name and image name
ObjectName = Var.Analysis.DispMeasObject{CallNum};
ImageName = Var.Analysis.DispMeasIntensity{CallNum};
%Get all measurements and the list of measurements to be displayed
Measurements = Var.Measurements.(ObjectName).(ImageName);
List = Var.Analysis.DispMeasMeasurements(CallNum,:);

%From the first leasurement in the list, get the Nb of objects
NbObjects = length(Measurements.(List{1}));
%And the Max Nb of frames
MaxNbFrame = 0;
for O = 1:NbObjects
    MaxNbFrame = max(MaxNbFrame, size(Measurements.(List{1}){O},1));
end
NbFrame = MaxNbFrame;
NbMeasurements = length(List);

%Gather all measurements in on 3D matrix
MeasurementsMatrix = zeros(NbObjects, NbFrame, NbMeasurements);
for M = 1:NbMeasurements
    for O = 1:NbObjects
        for F = 1:length(Measurements.(List{M}){O})
            MeasurementsMatrix(O,F,M) = Measurements.(List{M}){O}(F);
            if M == 1
                CheckLabelMatrix(O,F) = Measurements.CheckLabel{O}(F);
            end
        end
    end
end

%Get or generate time stamp
if isfield(Var.Analysis, 'TimeStamp')
    if strcmp(Var.Experiment.TimeUnit, 'hr')
      TimeAxis =(Var.Analysis.TimeStamp - Var.Analysis.TimeZero)./1000./60./60;
    elseif strcmp(Var.Experiment.TimeUnit, 'min')
      TimeAxis =(Var.Analysis.TimeStamp - Var.Analysis.TimeZero)./1000./60;
    elseif strcmp(Var.Experiment.TimeUnit, 'sec')
        TimeAxis =(Var.Analysis.TimeStamp - Var.Analysis.TimeZero)./1000;
    end
else
     TimeAxis = ([1:NbFrame]-(Var.Experiment.TimeZero)).*Var.Experiment.TimeStep;
end

%% Display of measurements

%if only tracked measurements should be displayed: Find which ones are the
%good ones based on the checklabel
if isfield(Var.Analysis, 'DisplayTracked') && strcmp(Var.Analysis.DisplayTracked,'Yes')
    MinLabel = min(CheckLabelMatrix,[],2);
    DiplaysObjects = find(MinLabel>0);
else
    DiplaysObjects = 1:NbObjects;
end


color = 'bcgyrm';
line = [' -'; '--'; ' :'; '-.'];
c = 1;
l = 1;
FigureNb =find((strcmp(Var.Figure.List, 'DispMeas')));
FigureNb = FigureNb(CallNum);

figure(FigureNb)
imagesc(Var.Img.(Var.Analysis.DispMeasImgDisplay))
colormap(gray)
set(gca,'ytick',[], 'xtick', [])

for k = 1:length(DiplaysObjects)
    %Generate object on blank image and get boundary
    O = DiplaysObjects(k);
    ObjectImage = zeros(size(Var.Img.(ImageName)));
    ObjectImage(Var.Measurements.(ObjectName).PixelList{NbFrame,O}) = 1;
    boundary = bwboundaries(ObjectImage);

%Dispaly boundrary on image
    for j=1:length(boundary)
        b = boundary{j};
        figure(FigureNb)
        hold on
        plot(b(:,2),b(:,1),[line(l,:),color(c)],'LineWidth',1);
        hold off
    end
    %Plot Measurements
    for i = 1:NbMeasurements
        figure(FigureNb+i)
        if k == 1
            clf('reset')
        end
        hold on
        plot(TimeAxis,MeasurementsMatrix(O,:,i), [line(l,:),color(c)],'LineWidth',1.3)
        hold off
        if O == 1
            TitleStr = [ List{i},' of ', ImageName, ' based on ', ObjectName];
            title(TitleStr); xlabel(['Time [',Var.Experiment.TimeUnit,']']); ylabel('[-]');
        end
    end
    c = c+1;
    if c > 6
        c = 1;
        l = l+1;
        if l > 4
            l = 1;
        end
    end
end

%% save images
 FileName = Var.Analysis.OutPath;

for i = 0:NbMeasurements
    if i == 0
        pict_name = [FileName,'_Legend.png'];
    else

        pict_name = [FileName,'_',ObjectName,'_',ImageName,'_',List{i},'.png'];
    end
    print('-dpng',(FigureNb+i),pict_name);
end


Hue = linspace(0,0.9,NbObjects);
HueB = rem(linspace(0.5,1.4,NbObjects),1);
    
if strcmp(Var.Analysis.SaveAvi, 'Yes')
    mov_name = [FileName,'_',ObjectName, '_Final.avi'];
    %mov_name = 'test.avi';
    aviobj = avifile(mov_name, 'fps', 2, 'Quality', 100, 'Compression', 'None'); %avifile(mov_name,'compression','None', 'fps', 2, 'Quality', 100);
    for i = 1:NbFrame
        %     ObjectImage = zeros(size(Var.Img.(ImageName)));
        %     for j = 1:NbObjects
        %         ObjectImage(Var.Measurements.(ObjectName).PixelList{i,j}) = j;
        %     end

        ObjectImageH = zeros(size(Var.Img.(ImageName)));
        ObjectImageS = zeros(size(Var.Img.(ImageName)));
        ObjectImageV = ones(size(Var.Img.(ImageName)));
        for j = 1:NbObjects
            ObjectImageH(Var.Measurements.(ObjectName).PixelList{i,j}) = Hue(j);
            % ObjectImageH(Var.Measurements.CombNuclObj.PixelList{i,j}) = HueB(j);
            ObjectImageS(Var.Measurements.(ObjectName).PixelList{i,j}) = 1;
            ObjectImageV(Var.Measurements.(ObjectName).PixelList{i,j}) = 1;
        end
        figure(FigureNb+NbMeasurements+1)
        %if strcmp(filesep, '\')
            pos = [180; 251; 896; 672];
            set(FigureNb+NbMeasurements+1, 'Position', pos)
        %end
        set(FigureNb+NbMeasurements+1, 'renderer', 'OpenGL')
        HSVObjectImage(:,:,1)  = ObjectImageH;
        HSVObjectImage(:,:,2)  = ObjectImageS;
        HSVObjectImage(:,:,3)  = ObjectImageV; %label2rgb(ObjectImage);

        RGBObjectImage = hsv2rgb(HSVObjectImage);
        iptsetpref('ImshowBorder','tight')
        image(RGBObjectImage)
        iptsetpref('ImshowBorder','loose')

        Center = [Var.Measurements.(ObjectName).CenterX{i}, Var.Measurements.(ObjectName).CenterY{i}];
        
        for m = 1:size(Center,1)
%             m = m;
%             C1 = Center(m,1);
%             C2 = Center(m,2);
%             L = Var.Measurements.(ObjectName).Label{i}(m);
            text(Center(m,1),Center(m,2), num2str(Var.Measurements.(ObjectName).Label{i}(m)), 'FontSize', 14); %
        end

        set(gca,'ytick',[], 'xtick', []);
        %     Frame = getframe(FigureNb+NbMeasurements+1);
        %     aviobj = addframe(aviobj,Frame);

        aviobj = addframe(aviobj,FigureNb+NbMeasurements+1);
    end



    aviobj = close(aviobj);
end

Var.Figure.NbPlotMeasFigs = NbMeasurements+1;