function Var = CorrectFlatness(Var, CallNum)

if nargin == 1
    CallNum = 1;
end

%Get Intensity image to correctImages
Image = Var.Img.(Var.Analysis.CorrFlatIn{CallNum});

%Get CCD image
CorrImgFolder = Var.Analysis.CorrImgFolder;
CCDFileName = fullfile(CorrImgFolder, [Var.Experiment.Microscope, '_CCD.tif']);
CCDImg = double(imread(CCDFileName));
%Get Flatness image
IllumFileName = fullfile(CorrImgFolder, [Var.Experiment.Microscope,'_',Var.Analysis.CorrFlatIllum{CallNum}, '_', Var.Experiment.Objective ,'x.tif']);
IllumImg = double(imread(IllumFileName));

%Smooth images:
%Using a disk average. Increase disk size to get stronger smoothing
h = fspecial('disk', 20);
CCDImg = imfilter(CCDImg, h, 'replicate');
IllumImg = imfilter(IllumImg, h, 'replicate');

%Subtract CCD Background to Illumination image
BinFactor = size(CCDImg,1)/size(IllumImg,1);
CCDImgBin = imresize(CCDImg, 1/BinFactor);
IllumImg = IllumImg-CCDImg;

%Subtract CCD Background to Intensity image
BinFactor = size(CCDImg,1)/size(Image,1);
CCDImg = imresize(CCDImg, 1/BinFactor);
Image = Image-CCDImg;

%correct flatness by normalizing using mean of Illumimg as  standard level

NormIllum = IllumImg./mean(IllumImg(:));
BinFactor = size(NormIllum,1)/size(Image,1);
NormIllum = imresize(NormIllum, 1/BinFactor);
CorrImage = Image./NormIllum;


%%% Display %%%
if strcmp(Var.Figure.Display, 'on')
    FigNum = find(strcmp(Var.Figure.List, 'CorrFlat'));
    figure(FigNum(CallNum))
    subplot(2,2,1); imagesc(Image);title('Intensity Image')
    subplot(2,2,2); imagesc(NormIllum); title('Fieldflatness');
    subplot(2,2,3); imagesc(CorrImage); title('Flattened Image');
end


%%% save %%%
Var.Img.(Var.Analysis.CorrFlatOUT{CallNum}) = CorrImage;