/*
 * Decompiled with CFR 0.152.
 */
package com.filemaker.jdbc2.optional;

import com.filemaker.jdbc.BaseConnection;
import com.filemaker.jdbc.FMSQLException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class PooledConnectionImpl
implements PooledConnection {
    private List listeners = new LinkedList();
    private Connection con;
    private ConnectionHandler last;
    private boolean autoCommit;
    static /* synthetic */ Class class$java$sql$Statement;
    static /* synthetic */ Class class$com$filemaker$jdbc$BaseStatement;
    static /* synthetic */ Class class$java$sql$CallableStatement;
    static /* synthetic */ Class class$java$sql$PreparedStatement;

    protected PooledConnectionImpl(Connection connection, boolean bl) {
        this.con = connection;
        this.autoCommit = bl;
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.add(connectionEventListener);
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.remove(connectionEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (this.last != null) {
            this.last.close();
            if (!this.con.getAutoCommit()) {
                try {
                    this.con.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        try {
            this.con.close();
        }
        finally {
            this.con = null;
        }
    }

    public Connection getConnection() throws SQLException {
        ConnectionHandler connectionHandler;
        if (this.con == null) {
            FMSQLException fMSQLException = new FMSQLException("This PooledConnection has already been closed!");
            this.fireConnectionFatalError(fMSQLException);
            throw fMSQLException;
        }
        try {
            if (this.last != null) {
                this.last.close();
                if (!this.con.getAutoCommit()) {
                    try {
                        this.con.rollback();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                this.con.clearWarnings();
            }
            this.con.setAutoCommit(this.autoCommit);
        }
        catch (FMSQLException fMSQLException) {
            this.fireConnectionFatalError(fMSQLException);
            throw (FMSQLException)fMSQLException.fillInStackTrace();
        }
        this.last = connectionHandler = new ConnectionHandler(this.con);
        Connection connection = (Connection)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Connection.class, BaseConnection.class}, (InvocationHandler)connectionHandler);
        this.last.setProxy(connection);
        return connection;
    }

    void fireConnectionClosed() {
        ConnectionEvent connectionEvent = null;
        ConnectionEventListener[] connectionEventListenerArray = this.listeners.toArray(new ConnectionEventListener[this.listeners.size()]);
        for (int i = 0; i < connectionEventListenerArray.length; ++i) {
            ConnectionEventListener connectionEventListener = connectionEventListenerArray[i];
            if (connectionEvent == null) {
                connectionEvent = new ConnectionEvent(this);
            }
            connectionEventListener.connectionClosed(connectionEvent);
        }
    }

    void fireConnectionFatalError(SQLException sQLException) {
        ConnectionEvent connectionEvent = null;
        ConnectionEventListener[] connectionEventListenerArray = this.listeners.toArray(new ConnectionEventListener[this.listeners.size()]);
        for (int i = 0; i < connectionEventListenerArray.length; ++i) {
            ConnectionEventListener connectionEventListener = connectionEventListenerArray[i];
            if (connectionEvent == null) {
                connectionEvent = new ConnectionEvent(this, sQLException);
            }
            connectionEventListener.connectionErrorOccurred(connectionEvent);
        }
    }

    private static class StatementHandler
    implements InvocationHandler {
        private ConnectionHandler con;
        private Statement st;

        public StatementHandler(ConnectionHandler connectionHandler, Statement statement) {
            this.con = connectionHandler;
            this.st = statement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if (method.getDeclaringClass().getName().equals("java.lang.Object")) {
                if (method.getName().equals("toString")) {
                    return "Pooled statement wrapping physical statement " + this.st;
                }
                if (method.getName().equals("hashCode")) {
                    return new Integer(this.st.hashCode());
                }
                if (method.getName().equals("equals")) {
                    if (objectArray[0] == null) {
                        return Boolean.FALSE;
                    }
                    try {
                        return Proxy.isProxyClass(objectArray[0].getClass()) && ((StatementHandler)Proxy.getInvocationHandler((Object)objectArray[0])).st == this.st ? Boolean.TRUE : Boolean.FALSE;
                    }
                    catch (ClassCastException classCastException) {
                        return Boolean.FALSE;
                    }
                }
                return method.invoke((Object)this.st, objectArray);
            }
            if (method.getName().equals("close")) {
                if (this.st == null || this.con.isClosed()) {
                    return null;
                }
                try {
                    this.st.close();
                }
                finally {
                    this.con = null;
                    this.st = null;
                }
                return null;
            }
            if (this.st == null || this.con.isClosed()) {
                throw new FMSQLException("Statement has been closed");
            }
            if (method.getName().equals("getConnection")) {
                return this.con.getProxy();
            }
            try {
                return method.invoke((Object)this.st, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getTargetException();
            }
        }
    }

    private class ConnectionHandler
    implements InvocationHandler {
        private Connection con;
        private Connection proxy;
        private boolean automatic = false;

        public ConnectionHandler(Connection connection) {
            this.con = connection;
        }

        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if (method.getDeclaringClass().getName().equals("java.lang.Object")) {
                if (method.getName().equals("toString")) {
                    return "Pooled connection wrapping physical connection " + this.con;
                }
                if (method.getName().equals("hashCode")) {
                    return new Integer(this.con.hashCode());
                }
                if (method.getName().equals("equals")) {
                    if (objectArray[0] == null) {
                        return Boolean.FALSE;
                    }
                    try {
                        return Proxy.isProxyClass(objectArray[0].getClass()) && ((ConnectionHandler)Proxy.getInvocationHandler((Object)objectArray[0])).con == this.con ? Boolean.TRUE : Boolean.FALSE;
                    }
                    catch (ClassCastException classCastException) {
                        return Boolean.FALSE;
                    }
                }
                try {
                    return method.invoke((Object)this.con, objectArray);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getTargetException();
                }
            }
            if (method.getName().equals("isClosed")) {
                return this.con == null ? Boolean.TRUE : Boolean.FALSE;
            }
            if (this.con == null && !method.getName().equals("close")) {
                if (this.automatic) {
                    throw new FMSQLException("[FileMaker][FileMaker JDBC] Connection has been closed automatically because a new connection was opened for the same PooledConnection or the PooledConnection has been closed");
                }
                throw new FMSQLException("[FileMaker][FileMaker JDBC] Connection has been closed");
            }
            if (method.getName().equals("close")) {
                if (this.con == null) {
                    return null;
                }
                FMSQLException fMSQLException = null;
                if (!this.con.getAutoCommit()) {
                    try {
                        this.con.rollback();
                    }
                    catch (FMSQLException fMSQLException2) {
                        fMSQLException = fMSQLException2;
                    }
                }
                this.con.clearWarnings();
                this.con = null;
                object = null;
                PooledConnectionImpl.this.last = null;
                PooledConnectionImpl.this.fireConnectionClosed();
                if (fMSQLException != null) {
                    throw fMSQLException;
                }
                return null;
            }
            if (method.getName().equals("createStatement")) {
                Statement statement = (Statement)method.invoke((Object)this.con, objectArray);
                return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{class$java$sql$Statement == null ? (class$java$sql$Statement = PooledConnectionImpl.class$("java.sql.Statement")) : class$java$sql$Statement, class$com$filemaker$jdbc$BaseStatement == null ? (class$com$filemaker$jdbc$BaseStatement = PooledConnectionImpl.class$("com.filemaker.jdbc.BaseStatement")) : class$com$filemaker$jdbc$BaseStatement}, (InvocationHandler)new StatementHandler(this, statement));
            }
            if (method.getName().equals("prepareCall")) {
                Statement statement = (Statement)method.invoke((Object)this.con, objectArray);
                return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{class$java$sql$CallableStatement == null ? (class$java$sql$CallableStatement = PooledConnectionImpl.class$("java.sql.CallableStatement")) : class$java$sql$CallableStatement, class$com$filemaker$jdbc$BaseStatement == null ? (class$com$filemaker$jdbc$BaseStatement = PooledConnectionImpl.class$("com.filemaker.jdbc.BaseStatement")) : class$com$filemaker$jdbc$BaseStatement}, (InvocationHandler)new StatementHandler(this, statement));
            }
            if (method.getName().equals("prepareStatement")) {
                Statement statement = (Statement)method.invoke((Object)this.con, objectArray);
                return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{class$java$sql$PreparedStatement == null ? (class$java$sql$PreparedStatement = PooledConnectionImpl.class$("java.sql.PreparedStatement")) : class$java$sql$PreparedStatement, class$com$filemaker$jdbc$BaseStatement == null ? (class$com$filemaker$jdbc$BaseStatement = PooledConnectionImpl.class$("com.filemaker.jdbc.BaseStatement")) : class$com$filemaker$jdbc$BaseStatement}, (InvocationHandler)new StatementHandler(this, statement));
            }
            return method.invoke((Object)this.con, objectArray);
        }

        Connection getProxy() {
            return this.proxy;
        }

        void setProxy(Connection connection) {
            this.proxy = connection;
        }

        public void close() {
            if (this.con != null) {
                this.automatic = true;
            }
            this.con = null;
            this.proxy = null;
        }

        public boolean isClosed() {
            return this.con == null;
        }
    }
}

