/*
 * Decompiled with CFR 0.152.
 */
package com.filemaker.jdbc1;

import java.io.IOException;
import java.io.InputStream;

public class FMInputStream
extends InputStream {
    private byte[] buffer;
    private int pos;
    private int markPosition = 0;

    public FMInputStream(byte[] byArray) {
        this.buffer = byArray;
    }

    public int read() throws IOException {
        try {
            if (this.pos >= this.buffer.length) {
                return -1;
            }
            int n = this.buffer[this.pos] & 0x7F;
            if ((this.buffer[this.pos] & 0x80) == 128) {
                n |= 0x80;
            }
            ++this.pos;
            return n;
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public void close() throws IOException {
        try {
            this.buffer = null;
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public synchronized void mark(int n) {
        this.markPosition = this.pos;
    }

    public synchronized void reset() throws IOException {
        try {
            this.pos = this.markPosition;
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public boolean markSupported() {
        return true;
    }
}

