/*
 * Decompiled with CFR 0.152.
 */
package com.filemaker.jdbc;

import com.filemaker.jdbc.FMSQLException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.Hashtable;

public class Encoding {
    private static final Encoding DEFAULT_ENCODING = new Encoding("UTF-8");
    private static final Hashtable encodings = new Hashtable();
    private final String encoding;
    private static final int pow2_6 = 64;
    private static final int pow2_12 = 4096;
    private char[] cdata = new char[50];

    private Encoding(String string) {
        this.encoding = string;
    }

    public static Encoding getEncoding(String string, String string2) {
        if (string2 != null) {
            if (Encoding.isAvailable(string2)) {
                return new Encoding(string2);
            }
            return Encoding.defaultEncoding();
        }
        return Encoding.encodingForDatabaseEncoding(string);
    }

    private static Encoding encodingForDatabaseEncoding(String string) {
        if (encodings.containsKey(string)) {
            String[] stringArray = (String[])encodings.get(string);
            for (int i = 0; i < stringArray.length; ++i) {
                if (!Encoding.isAvailable(stringArray[i])) continue;
                return new Encoding(stringArray[i]);
            }
        }
        return Encoding.defaultEncoding();
    }

    public String name() {
        return this.encoding;
    }

    public byte[] encode(String string) throws SQLException {
        try {
            byte[] byArray = this.encoding == null ? string.getBytes() : string.getBytes(this.encoding);
            if (byArray == null) {
                return new byte[0];
            }
            return byArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new FMSQLException(unsupportedEncodingException.getMessage(), "22000");
        }
    }

    public String decode(byte[] byArray, int n, int n2) throws SQLException {
        try {
            if (this.encoding == null) {
                return new String(byArray, n, n2);
            }
            return new String(byArray, n, n2, this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new FMSQLException(unsupportedEncodingException.getMessage(), "22000");
        }
    }

    public String decode(byte[] byArray) throws SQLException {
        return this.decode(byArray, 0, byArray.length);
    }

    public Reader getDecodingReader(InputStream inputStream) throws SQLException {
        try {
            if (this.encoding == null) {
                return new InputStreamReader(inputStream);
            }
            return new InputStreamReader(inputStream, this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new FMSQLException(unsupportedEncodingException.getMessage(), "22000");
        }
    }

    public static Encoding defaultEncoding() {
        return DEFAULT_ENCODING;
    }

    private static boolean isAvailable(String string) {
        try {
            "DUMMY".getBytes(string);
            return true;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
    }

    private synchronized String decodeUTF8(byte[] byArray, int n, int n2) throws SQLException {
        try {
            char[] cArray = this.cdata;
            if (cArray.length < n2) {
                cArray = new char[n2];
            }
            int n3 = n;
            int n4 = 0;
            int n5 = n2 + n;
            while (n3 < n5) {
                int n6;
                int n7;
                int n8 = byArray[n3] & 0xFF;
                if (n8 < 128) {
                    cArray[n4++] = (char)byArray[n3];
                    ++n3;
                    continue;
                }
                if (n8 >= 224) {
                    n7 = byArray[n3 + 1] & 0xFF;
                    int n9 = byArray[n3 + 2] & 0xFF;
                    n6 = (n8 - 224) * 4096 + (n7 - 128) * 64 + (n9 - 128);
                    cArray[n4++] = (char)n6;
                    n3 += 3;
                    continue;
                }
                n7 = byArray[n3 + 1] & 0xFF;
                n6 = (n8 - 192) * 64 + (n7 - 128);
                cArray[n4++] = (char)n6;
                n3 += 2;
            }
            String string = new String(cArray, 0, n4);
            return string;
        }
        catch (Exception exception) {
            throw new FMSQLException("Invalid character data was found.");
        }
    }

    static {
        encodings.put("SQL_ASCII", new String[]{"ASCII", "us-ascii"});
        encodings.put("UNICODE", new String[]{"UTF-8", "UTF8"});
        encodings.put("LATIN1", new String[]{"ISO8859_1"});
        encodings.put("LATIN2", new String[]{"ISO8859_2"});
        encodings.put("LATIN3", new String[]{"ISO8859_3"});
        encodings.put("LATIN4", new String[]{"ISO8859_4"});
        encodings.put("ISO_8859_5", new String[]{"ISO8859_5"});
        encodings.put("ISO_8859_6", new String[]{"ISO8859_6"});
        encodings.put("ISO_8859_7", new String[]{"ISO8859_7"});
        encodings.put("ISO_8859_8", new String[]{"ISO8859_8"});
        encodings.put("LATIN5", new String[]{"ISO8859_9"});
        encodings.put("LATIN7", new String[]{"ISO8859_13"});
        encodings.put("LATIN9", new String[]{"ISO8859_15_FDIS"});
        encodings.put("EUC_JP", new String[]{"EUC_JP"});
        encodings.put("EUC_CN", new String[]{"EUC_CN"});
        encodings.put("EUC_KR", new String[]{"EUC_KR"});
        encodings.put("JOHAB", new String[]{"Johab"});
        encodings.put("EUC_TW", new String[]{"EUC_TW"});
        encodings.put("SJIS", new String[]{"MS932", "SJIS"});
        encodings.put("BIG5", new String[]{"Big5", "MS950", "Cp950"});
        encodings.put("GBK", new String[]{"GBK", "MS936"});
        encodings.put("UHC", new String[]{"MS949", "Cp949", "Cp949C"});
        encodings.put("TCVN", new String[]{"Cp1258"});
        encodings.put("WIN1256", new String[]{"Cp1256"});
        encodings.put("WIN1250", new String[]{"Cp1250"});
        encodings.put("WIN874", new String[]{"MS874", "Cp874"});
        encodings.put("WIN", new String[]{"Cp1251"});
        encodings.put("ALT", new String[]{"Cp866"});
        encodings.put("KOI8", new String[]{"KOI8_U", "KOI8_R"});
        encodings.put("UNKNOWN", new String[0]);
        encodings.put("MULE_INTERNAL", new String[0]);
        encodings.put("LATIN6", new String[0]);
        encodings.put("LATIN8", new String[0]);
        encodings.put("LATIN10", new String[0]);
    }
}

