function [Var] = ScreenAverage(Var)

%Calculate the mean growth rate over all screen
%loop Through all screens
if Var.Analysis.Type == 1
    AllMeas = Var.File.NumberOfScreen;
else
    AllMeas = Var.File.NumberOfScreen + floor(Var.File.NumberOfScreen/2);
end
for i = 1:AllMeas
    %Initiate variables
    ScreenSum = zeros(Var.File.NumberOfPlates{i}, Var.Plate.Dilution);
    ScreenStd = zeros(Var.File.NumberOfPlates{i}, Var.Plate.Dilution);
    for j = 1:Var.File.NumberOfPlates{i}
        %Calculate the mean and std for each plate for all dilutions
        ScreenSum(j,:) = mean(Var.Measurement{i,j}.Sum,1);
        ScreenStd(j,:) = std(Var.Measurement{i,j}.Sum,1);
    end
    %Calculate the mean over the whole screen
    Var.Measurement{i}.AverageScreenSum = mean(ScreenSum,1);
    Var.Measurement{i}.AverageScreenStd = mean(ScreenStd,1);
end


%Calculate growth rate of selected ORFs
%check if reference ORF have been selected
if isfield(Var.File, 'NumberOfOrf')
    %Loop through all screens
    for i = 1:Var.File.NumberOfScreen
        %Loop Through all selected ORF
        for j = 1:Var.File.NumberOfOrf
            %Define position in measurement array
            LinearPosition = (Var.File.ReferenceOrfPosition(j,2)-1)*Var.Plate.StrainDisposition(1)+Var.File.ReferenceOrfPosition(j,3);
            %Save measurements to variable
            SelectedOrfMeasurement(j,:) = Var.Measurement{i,Var.File.ReferenceOrfPosition(j,1)}.Sum(LinearPosition,:);
        end
        %Calculate average and std of measurements
        Var.Measurement{i}.AverageSelectedORF = mean(SelectedOrfMeasurement,1);
        %Calculate the difference in growth between Average from screen and
        %selected ORFs
        Var.Measurement{i}.DeviationSelectedORF = Var.Measurement{i}.AverageSelectedORF./Var.Measurement{i}.AverageScreenSum;
        %Set min and Max growth rate using defined thresholds
        if mean(Var.File.ThreshList(i,:)) ~= 0
            Var.Measurement{i}.MinGrowth = Var.Measurement{i}.DeviationSelectedORF.*Var.File.ThreshList(i,1).*Var.Measurement{i}.AverageScreenSum;
            Var.Measurement{i}.MaxGrowth = Var.Measurement{i}.DeviationSelectedORF.*Var.File.ThreshList(i,2).*Var.Measurement{i}.AverageScreenSum;

        end
    end

end

if Var.File.DisplayMode == 1
    for i = 1:Var.File.NumberOfScreen
    % the average growth rate from the selected orfs is used for displaying the images
    Var.Measurement{i}.AverageScreenSum = Var.Measurement{i}.AverageSelectedORF;
    end
end

Var.Analysis.AverageMeasured = 1;