function Var = LoadSavedMeasurements(Var)

MeasFile = fullfile(Var.File.ResultFolder{Var.Analysis.CurrentScreen}, ['Meas_', Var.File.FileRoot{Var.Analysis.CurrentScreen},'.txt']);

files = dir(MeasFile);

% If run analysis
if Var.Display.PlateDisplay == 0
    if ~isempty(files)
        Question = 'Found previously saved Measurements do you want to use them?';
        button = questdlg(Question,Var.File.FileRoot{Var.Analysis.CurrentScreen},'Yes','Overwrite', 'Yes');
        if strcmp(button, 'Yes')
            Var.Plate.LoadedMeas{Var.Analysis.CurrentScreen} = 1;
            %open file
            fid = fopen(MeasFile);
            %Search through begining of file until it reaches a cell which
            %equivalent to the first ORF found in the database.
            FirstORF = 0;
            while FirstORF == 0
                [TestORF] = textscan(fid, '%s',1, 'delimiter', '\t');
                if strcmp(char(TestORF{1}), Var.Plate.ORF{4}(1,:))
                    FirstORF = 1;
                end
            end
            %reset the cursor to the position before the read number
            fseek(fid, -1, 'cof'); %*length(Var.Plate.ORF{4}(1,:))
            %Read through measurement file
            FormatStr = ['%s%n%n%n'];
            for i = 1:Var.Plate.Dilution
                FormatStr = [FormatStr, '%n'];
            end
            [Measurements] = textscan(fid, FormatStr, 'delimiter', '\t');
            assignin('base','MeasLoad',Measurements);
            %Measurements is a cell array. the first column of the cell contains the
            %ORF, the second the plate number, the third, the line number, the fourth
            %the column number Then the next columns contain the Measurments
            NbStrain = Var.Plate.Spot(1)*Var.Plate.Spot(2)/Var.Plate.Dilution;
            NbSpot = Var.Plate.Dilution;
            NbPlate = Var.File.NumberOfPlates{Var.Analysis.CurrentScreen};
            iter = 0;
            for i = 1:NbPlate
                for j = 1:NbStrain
                    iter = iter+1;
                    for k = 1:Var.Plate.Dilution
                        Var.Measurement{Var.Analysis.CurrentScreen,i}.Sum(j,k) = Measurements{k + 4}(iter);
                    end
                end
            end
            assignin('base','Var_Load',Var);
        else
            Var.Plate.LoadedMeas{Var.Analysis.CurrentScreen} = 0;
        end
    else
        Var.Plate.LoadedMeas{Var.Analysis.CurrentScreen} = 0;
    end
elseif Var.Display.PlateDisplay == 1
    %IF only plate display check if are not already in Var
    Var.Plate.LoadedMeas{Var.Analysis.CurrentScreen} = 1;
    if ~(isfield(Var, 'Measurement') && size(Var.Measurement,1) >= Var.File.NumberOfScreen)
        if ~isempty(files)
            %open file
            fid = fopen(MeasFile);
            %Search through begining of file until it reaches a cell which
            %equivalent to the first ORF found in the database.
            FirstORF = 0;
            while FirstORF == 0
                [TestORF] = textscan(fid, '%s',1, 'delimiter', '\t');
                if strcmp(char(TestORF{1}), Var.Plate.ORF{4}(1,:))
                    FirstORF = 1;
                end
            end
            %reset the cursor to the position before the read number
            fseek(fid, -1, 'cof'); %*length(Var.Plate.ORF{4}(1,:))
            %Read through measurement file
            FormatStr = ['%s%n%n%n'];
            for i = 1:Var.Plate.Dilution
                FormatStr = [FormatStr, '%n'];
            end
            [Measurements] = textscan(fid, FormatStr, 'delimiter', '\t');
            assignin('base','MeasLoad',Measurements);
            %Measurements is a cell array. the first column of the cell contains the
            %ORF, the second the plate number, the third, the line number, the fourth
            %the column number Then the next columns contain the Measurments
            NbStrain = Var.Plate.Spot(1)*Var.Plate.Spot(2)/Var.Plate.Dilution;
            NbSpot = Var.Plate.Dilution;
            NbPlate = Var.File.NumberOfPlates{Var.Analysis.CurrentScreen};
            iter = 0;
            for i = 1:NbPlate
                for j = 1:NbStrain
                    iter = iter+1;
                    for k = 1:Var.Plate.Dilution
                        Var.Measurement{Var.Analysis.CurrentScreen,i}.Sum(j,k) = Measurements{k + 4}(iter);
                    end
                end
            end
            assignin('base','Var_Load',Var);
        else
            TitleStr = 'No Measurements';
            WarnStr = 'No Measurement File found please run the screen first';
            h = warndlg(WarnStr,TitleStr);
            return
        end
    end
end


