function [Var] = CompareScreen(Var)

NbStrain = Var.Plate.Spot(1)*Var.Plate.Spot(2)/Var.Plate.Dilution;
NbSpot = Var.Plate.Dilution;
NbScreen = Var.File.NumberOfScreen;


%create empty matrix for image display in gene array fashion
if Var.Analysis.Type == 1
    NbScreenDisp = NbScreen;
else
    NbScreenDisp = floor(NbScreen/2);
end
Blank = ones(Var.Display.DispGrid*(NbStrain+2)+1,(Var.Display.DispGrid*NbSpot)*NbScreenDisp+1+Var.Display.DispGrid*(NbScreenDisp-1));

Blank(1:Var.Display.DispGrid:end,:) = 0;
Blank(:,1:Var.Display.DispGrid:end) = 0;

[LabelBlank, NbPatch] = bwlabel(Blank);
Blankprops =regionprops(LabelBlank, 'PixelIdxList');


Deviation = zeros(NbStrain, (NbSpot+1)*NbScreenDisp-1);
Threshold = zeros(NbStrain, (NbSpot+1)*NbScreenDisp-1);
%Check if raw data is displayed
if Var.Analysis.Type == 1
    
    for i = 1:NbScreen
        %Calculate deviation from mean
        %std is the reference deviation: 1std => 1/StdFactor deviation from mean;
        SumAvg_2D = ones(NbStrain,1)*Var.Measurement{i}.AverageScreenSum;
        StdAvg_2D = ones(NbStrain,1)*Var.Measurement{i}.AverageScreenStd;
        StdFactor = 3;
        %PN = Var.File.PlateNumber(i,Var.Analysis.CurrentPlate)
        Deviation(1:NbStrain,(NbSpot+1)*(i-1)+1:(NbSpot+1)*(i)-1) = (Var.Measurement{i,Var.File.PlateNumber(i,Var.Analysis.CurrentPlate)}.Sum - SumAvg_2D)./(StdFactor.*StdAvg_2D);
        
        if mean(Var.File.ThreshList(i,:)) ~= 0
            for j = 1:NbSpot
                row_index = find(Var.Measurement{i,Var.File.PlateNumber(i,Var.Analysis.CurrentPlate)}.Sum(:,j)>=Var.Measurement{i}.MinGrowth(1,j) & Var.Measurement{i,Var.File.PlateNumber(i,Var.Analysis.CurrentPlate)}.Sum(:,j)<=Var.Measurement{i}.MaxGrowth(1,j));
                col_index = ones(length(row_index),1).*(j+(NbSpot+1)*(i-1));
                index_2D = sub2ind([NbStrain, (NbSpot+1)*NbScreen-1],row_index,col_index);
                Threshold(index_2D) = 1;
                Deviation(index_2D) = 0;
            end
        end
    end
    %Calculate deviation for results matrices
else
    iter = 0;
    for i = NbScreen+1:NbScreen + floor(NbScreen/2)
        iter = iter+1;
        %Calculate deviation from mean
        %std is the reference deviation: 1std => 1/StdFactor deviation from mean;
        SumAvg_2D = ones(NbStrain,1)*Var.Measurement{i}.AverageScreenSum;
        StdAvg_2D = ones(NbStrain,1)*Var.Measurement{i}.AverageScreenStd;
        StdFactor = 3;
        %PN = Var.File.PlateNumber(i,Var.Analysis.CurrentPlate)
        Deviation(1:NbStrain,(NbSpot+1)*(iter-1)+1:(NbSpot+1)*(iter)-1) = (Var.Measurement{i,Var.File.PlateNumber(i,Var.Analysis.CurrentPlate)}.Sum - SumAvg_2D)./(StdFactor.*StdAvg_2D);
        %
        %     if mean(Var.File.ThreshList(i,:)) ~= 0
        %         for j = 1:NbSpot
        %             row_index = find(Var.Measurement{i,Var.File.PlateNumber(i,Var.Analysis.CurrentPlate)}.Sum(:,j)>=Var.Measurement{i}.MinGrowth(1,j) & Var.Measurement{i,Var.File.PlateNumber(i,Var.Analysis.CurrentPlate)}.Sum(:,j)<=Var.Measurement{i}.MaxGrowth(1,j));
        %             col_index = ones(length(row_index),1).*(j+(NbSpot+1)*(i-1));
        %             index_2D = sub2ind([NbStrain, (NbSpot+1)*NbScreenDisp-1],row_index,col_index);
        %             Threshold(index_2D) = 1;
        %             Deviation(index_2D) = 0;
        %         end
        %     end
    end
end
assignin('base', 'Deviation', Deviation)
assignin('base', 'Threshold', Threshold)
assignin('base', 'Deviation', Deviation)
assignin('base', 'Var_CS', Var)

LargeDev = find(Deviation > 1);
Deviation(LargeDev) = 1;
LargeDev = find(Deviation < -1);
Deviation(LargeDev) = -1;

%Add reference Std values to image
Deviation(NbStrain+1,:) = 1/StdFactor;
Deviation(NbStrain+2,:) = -1/StdFactor;

%Set threshold to zero for reference Std values in image
Threshold(NbStrain+1:NbStrain+2,:) = 0;




%% Create image
BlueImg = zeros(size(Blank));
GreenImg = zeros(size(Blank));
RedImg = zeros(size(Blank));

%Find negative deviations
NegDev = find(Deviation < 0);

%Report Negative variation in Red image
for n = 1:length(NegDev)
    RedImg(Blankprops(NegDev(n)).PixelIdxList) = -Deviation(NegDev(n));
end

%Find Positive deviations
PosDev = find(Deviation >= 0);

%Report Positive variation in Green image
for n = 1:length(PosDev)
    GreenImg(Blankprops(PosDev(n)).PixelIdxList) = Deviation(PosDev(n));
end

%Find Threshold  equal to 1
ValidThresh = find(Threshold >= 0);

%Report Active threshold in Blue image
for n = 1:length(ValidThresh)
    BlueImg(Blankprops(ValidThresh(n)).PixelIdxList) = Threshold(ValidThresh(n));
end


% BlueImg(Blankprops(384).PixelIdxList) = 1;
% RedImg(Blankprops(384).PixelIdxList) = 1;
% GreenImg(Blankprops(384).PixelIdxList) = 1;

%generate RGB image
DeviationImg(:,:,1) = RedImg';
DeviationImg(:,:,2) = GreenImg';
DeviationImg(:,:,3) = BlueImg';

Var.Display.DeviationImg = DeviationImg;

ImgSize = [1500,80*NbScreenDisp];
assignin('base', 'Var_Add', Var)


%% Integrate data from .txt database
for i = 1:NbScreen
    if isfield(Var.Plate, Var.File.FileRoot{i})
        StartPt = (Var.Analysis.CurrentPlate-1)*Var.Plate.StrainDisposition(1)*Var.Plate.StrainDisposition(2)+1;
        EndPt = Var.Analysis.CurrentPlate*Var.Plate.StrainDisposition(1)*Var.Plate.StrainDisposition(2);
        PlateInfo = Var.Plate.(Var.File.FileRoot{i})(StartPt:EndPt);
        
        %Find strains labelled with Y for Yellow
        YellowStrains = strfind(PlateInfo', 'Y');
        if ~isempty(YellowStrains)
            %Generate blank image
            YellowImg = zeros(size(Blank));
            for c = 1:length(YellowStrains)
                for s = 0:NbSpot-1
                    %Assign spots to the correct strains 
                    YellowImg(Blankprops((i-1)*(NbStrain+2)*NbSpot + s*(NbStrain+2) + YellowStrains(c)).PixelIdxList) = 1;
                end
            end
            %             figure(100)
            %             imagesc(YellowImg')
            
            %Set values for Red and Green Image
            RedImg(YellowImg == 1) = 1;
            GreenImg(YellowImg == 1) = 1;
            BlueImg(YellowImg == 1) = 0;
            %generate RGB image
            DeviationImg(:,:,1) = RedImg';
            DeviationImg(:,:,2) = GreenImg';
            DeviationImg(:,:,3) = BlueImg';
            
            Var.Display.DeviationImg = DeviationImg;
        end
        
        
        
        
        %Find strains labelled with C for Cyan
        CyanStrains = strfind(PlateInfo', 'C');
        if ~isempty(CyanStrains)
            CyanImg = zeros(size(Blank));
            for c = 1:length(CyanStrains)
                for s = 0:NbSpot-1
                    CyanImg(Blankprops((i-1)*(NbStrain+2)*NbSpot + s*(NbStrain+2) + CyanStrains(c)).PixelIdxList) = 1;
                end
            end
            %             figure(100)
            %             imagesc(CyanImg')
            RedImg(CyanImg == 1) = 0;
            GreenImg(CyanImg == 1) = 1;
            BlueImg(CyanImg == 1) = 1;
            %generate RGB image
            DeviationImg(:,:,1) = RedImg';
            DeviationImg(:,:,2) = GreenImg';
            DeviationImg(:,:,3) = BlueImg';
            
            Var.Display.DeviationImg = DeviationImg;
        end
        
        
        %Find strains labelled with M for Magenta
        MagentaStrains = strfind(PlateInfo', 'M');
        
        if ~isempty(MagentaStrains)
            MagentaImg = zeros(size(Blank));
            for c = 1:length(MagentaStrains)
                for s = 0:NbSpot-1
                    MagentaImg(Blankprops((i-1)*(NbStrain+2)*NbSpot + s*(NbStrain+2) + MagentaStrains(c)).PixelIdxList) = 1;
                end
            end
%             figure(100)
%             imagesc(MagentaImg')
            
            RedImg(MagentaImg == 1) = 1;
            GreenImg(MagentaImg == 1) = 0;
            BlueImg(MagentaImg == 1) = 1;
            %generate RGB image
            DeviationImg(:,:,1) = RedImg';
            DeviationImg(:,:,2) = GreenImg';
            DeviationImg(:,:,3) = BlueImg';
            
            Var.Display.DeviationImg = DeviationImg;
        end
        
    end
end




%% Figure display
%Closes the previous figure before displaying the next one
%Not sure it is a good thing...
if isfield(Var.Display, 'FigHand') && Var.Display.PlateDisplay == 1
    %close image
    try
        close(Var.Display.FigHand)
    end
end

Var.Display.FigHand = figure('Units','pixels','Position',[20 20 ImgSize(1) ImgSize(2)]);
set(gcf,'PaperPositionMode','auto')
FigTitle = ['Plate # ', num2str(Var.File.PlateNumber(1,Var.Analysis.CurrentPlate))];
image(DeviationImg, 'ButtondownFcn', {@GetCoord LabelBlank Var}, 'UserData',Var.File.PlateNumber(1,Var.Analysis.CurrentPlate))
title(FigTitle)

TickRepeat = Var.Plate.Spot(1)/Var.Plate.Strain(1);
j = 0;
for i = 1:NbStrain/TickRepeat
    j = j+1;
    TixLabel{j} = ['Line_' num2str(i)];
end
TixLabel{j+1}  = 'Ref Std';

set(gca,'TickDir', 'out')
set(gca,'XTick',[Var.Display.DispGrid/2:TickRepeat*Var.Display.DispGrid:Var.Display.DispGrid*(NbStrain+2)+1])
set(gca,'XTickLabel',TixLabel)
set(gcf,'Pointer','crosshair')
%set(gca,'ButtondownFcn', @SetCoord)

if Var.Analysis.Type == 1
    m = 0;
    for i = 1:NbScreenDisp
        for j = 1:NbSpot +1
            m = m+1;
            if j ~= (NbSpot+1)
                TixLabel{m} = [Var.File.FileRoot{i}, ' ', num2str(j)];
            else
                TixLabel{m} = ' ';
            end
        end
    end
else
    if Var.Analysis.Type == 2
        Calc = ' - ';
    elseif Var.Analysis.Type == 3
        Calc = ' / ';
    end
    m = 0;
    for i = 1:NbScreenDisp
        for j = 1:NbSpot +1
            m = m+1;
            if j ~= (NbSpot+1)
                TixLabel{m} = [Var.File.FileRoot{2*i-1}, Calc ,Var.File.FileRoot{2*i}, ' ', num2str(j)];
            else
                TixLabel{m} = ' ';
            end
        end
    end
end

set(gca,'yTick',[Var.Display.DispGrid/2:Var.Display.DispGrid:Var.Display.DispGrid*((NbSpot+1)*NbScreenDisp-1)])
set(gca,'YTickLabel',TixLabel )

if 0 == 1
    F = GetCoord;
end

% Display ORF colonies if needed
if ~strcmp(Var.Display.ORFDisplayName, 'ORF')
    %Place a rectangle arounf ORF in Deviation Img
    StrainNum = (Var.Display.ORFDisplayRow-1)*Var.Plate.StrainDisposition(1)+Var.Display.ORFDisplayCol;
    StrainPix = find(LabelBlank(:,5) ==StrainNum);
    YALim = get(gca, 'YLim');
    rectangle('Position',[min(StrainPix)-2,2,Var.Display.DispGrid+1,YALim(2)-1], 'EdgeColor', 'b', 'LineWidth', 2)
    %Display colonies from ORF
    ORFPosition = [Var.Display.PlateNum, Var.Display.ORFDisplayRow, Var.Display.ORFDisplayCol];
    DisplayORFColonies(Var, Var.Display.ORFDisplayName, ORFPosition)
end



%Generate filename for image saving
if Var.Analysis.Type == 1
    FileName = ['Size_'];
    for i = 1:NbScreenDisp
        FileName = [FileName, Var.File.FileRoot{i}, '_'];
    end
elseif Var.Analysis.Type == 2
    FileName = ['Diff_'];
    for i = 1:NbScreenDisp
        FileName = [FileName, Var.File.FileRoot{2*i-1}, Var.File.FileRoot{2*i}, '_'];
    end
elseif Var.Analysis.Type == 3
    FileName = ['Ratio_'];
    for i = 1:NbScreenDisp
        FileName = [FileName, Var.File.FileRoot{2*i-1}, Var.File.FileRoot{2*i}, '_'];
    end
end

FileName = [FileName, num2str(Var.File.PlateNumber(1,Var.Analysis.CurrentPlate)), '.png'];
%Filename = fullfile(Var.File.ResultFolder,FileName)
FigStr = ['-f', num2str(Var.Display.FigHand)];
cd(Var.File.ResultFolder{1})
print(FigStr, '-dpng',FileName); %,'-r1200'
cd(Var.File.CodeFolder)

if Var.Display.PlateDisplay == 0
    %close image
    close(Var.Display.FigHand)
end

%% Get the ORFName and position when clicking on the deviationimage

function F = GetCoord(src,eventdata, LabelBlank, Var)

%fprintf('function active')
AxesHandles = get(src, 'Parent');
MousePosition = get(AxesHandles, 'CurrentPoint');

PlateNum = get(src, 'UserData');


StrainNum = LabelBlank(round(MousePosition(1,1)), 5);
if StrainNum == 0
    fprintf('You clicked on the border between two cells')
else
    StrainPix = find(LabelBlank(:,5) ==StrainNum);
    YALim = get(gca, 'YLim');
    rectangle('Position',[min(StrainPix)-2,2,Var.Display.DispGrid+1,YALim(2)-1], 'EdgeColor', 'b', 'LineWidth', 2)
    ORFName = Var.Plate.ORF{4}((PlateNum-1)*Var.Plate.StrainDisposition(1)*Var.Plate.StrainDisposition(2) + StrainNum,:);
    ORFRow = Var.Plate.ORF{2}((PlateNum-1)*Var.Plate.StrainDisposition(1)*Var.Plate.StrainDisposition(2) + StrainNum,:);
    ORFCol = Var.Plate.ORF{3}((PlateNum-1)*Var.Plate.StrainDisposition(1)*Var.Plate.StrainDisposition(2) + StrainNum,:);
    
    [ProtName, Function] = ORF2name(ORFName);
    FigTitle = ['Plate # ', num2str(PlateNum), ' ', ORFName, ': ', ProtName, ', ', Function];
    title(FigTitle)
    DisplayORFColonies(Var, ORFName, [PlateNum, ORFRow, ORFCol]);
    
    %
    %     figure(Var.Display.FigHand+1)
    %     set(Var.Display.FigHand+1, 'Position', [100   650   Var.File.NumberOfScreen*250   230], 'Name', FigTitle)
    %
    %
    %     for ScreenNum = 1:Var.File.NumberOfScreen
    %         %load Grid file
    %         cd(Var.File.ResultFolder{ScreenNum})
    %         SavedGridName = ['Grid_', Var.File.FileName{ScreenNum}(PlateNum).name(1:end-4) '.mat'];
    %         load(SavedGridName)
    %         cd(Var.File.CodeFolder)
    %         %Transfer grid info to variables
    %         HLines = GridSpecs.HLines;
    %         VLines = GridSpecs.VLines;
    %         %         HLines = Var.Plate.HLines{ScreenNum, PlateNum};
    %         %         VLines = Var.Plate.VLines{ScreenNum, PlateNum};
    %         YPos(1) = HLines((ORFRow-1)*2+1);
    %         YPos(2) = HLines((ORFRow)*2+1);
    %         XPos(1) = VLines((ORFCol-1)*2+1);
    %         XPos(2) = VLines((ORFCol)*2+1);
    %
    %         Xcorners = [XPos(1),XPos(2),XPos(2), XPos(1),XPos(1)];
    %         Ycorners = [YPos(1),YPos(1),YPos(2), YPos(2),YPos(1)];
    %         subplot(1,Var.File.NumberOfScreen,ScreenNum)
    %         FileName = fullfile(Var.File.DataFolder{ScreenNum},Var.File.FileName{ScreenNum}(Var.Display.PlateNum).name);
    %         Img = imread(FileName, 'tif');
    %         imshow(Img); colormap(gray)
    %         %imshow(Img); colormap(gray)
    %         hold on
    %         plot(Xcorners, Ycorners, 'r', 'Linewidth', 2)
    %         hold off
    %         axis([ XPos(1)-10  XPos(2)+10  YPos(1)-10  YPos(2)+10])
    %         title(Var.File.FileRoot{ScreenNum})
    %     end
    
end

%% %Display the colonies from a given ORF on a plate knowing the plate
% number and the column and Line

function F = DisplayORFColonies(Var, ORFName, ORFPosition)
%ORFPosition is a three line vector with the plate number, the Row and the
%column

figure(Var.Display.FigHand+1)
set(Var.Display.FigHand+1,'Name', ['Plate # ', num2str(ORFPosition(1)), ' ', ORFName])
%set(Var.Display.FigHand+1, 'Position', [100   650   Var.File.NumberOfScreen*250   230], 'Name', ['Plate # ', num2str(ORFPosition(1)), ' ', ORFName])
drawnow

for ScreenNum = 1:Var.File.NumberOfScreen
    %load Grid file
    cd(Var.File.ResultFolder{ScreenNum})
    SavedGridName = ['Grid_', Var.File.FileName{ScreenNum}(ORFPosition(1)).name(1:end-4) '.mat'];
    load(SavedGridName)
    cd(Var.File.CodeFolder)
    %Transfer grid info to variables
    HLines = GridSpecs.HLines;
    VLines = GridSpecs.VLines;
    YPos(1) = HLines((ORFPosition(2)-1)*Var.Plate.Strain(2)+1);
    YPos(2) = HLines((ORFPosition(2))*Var.Plate.Strain(2)+1);
    XPos(1) = VLines((ORFPosition(3)-1)*Var.Plate.Strain(1)+1);
    XPos(2) = VLines((ORFPosition(3))*Var.Plate.Strain(1)+1);
    
    Xcorners = [XPos(1),XPos(2),XPos(2), XPos(1),XPos(1)];
    Ycorners = [YPos(1),YPos(1),YPos(2), YPos(2),YPos(1)];
    subplot(1,Var.File.NumberOfScreen,ScreenNum)
    FileName = fullfile(Var.File.DataFolder{ScreenNum},Var.File.FileName{ScreenNum}(ORFPosition(1)).name);
    Img = imread(FileName, 'tif');
    imshow(Img); colormap(gray)
    %imshow(Img); colormap(gray)
    hold on
    plot(Xcorners, Ycorners, 'r', 'Linewidth', 2)
    hold off
    axis([ XPos(1)-10  XPos(2)+10  YPos(1)-10  YPos(2)+10])
    title(Var.File.FileRoot{ScreenNum})
end

