#Title: runSaveOverlayedImages.R
#Type: Script
#Version: 1.0
#Date: 2014-03-07
#Author: Martial Sankar
#Maintainer: Martial Sankar <martial.sankar@unil.ch>
#Description: command line R tool for automated generation of overlayed image (raw + segmentation)
#License: GPL (>= 2)
#Depends: R (>= 2.14.0)
#OS_type: unix
#Depends on: halfdawn_function.R
#URL: http://www3.unil.ch/wpmu/hardtkelab/

source("~/local/secGrowth/dev/script/halfdawn_function.R")
args <- commandArgs(trailingOnly = TRUE)
folder <- args[1]

fns <- dir(folder, full.names = TRUE)
all <-  grep( ".tif", fns, value=T)
segs <- grep( "segmented", all, value=T)

for (i in 1:length(segs)){
	rawNm <-  gsub( "_segmented", "",segs[i])
	raw <- readImage(rawNm)
	cat("#Raw::",rawNm,"\n")
	cat("#Segs::",segs[i],"\n")
	ut <- untile(raw, c(2, 2))
	imssave<-tile(ut, nx=2, lwd=0)
	res <- 	saveOverlayImage(imSeg=segs[i], imRaw=imssave)
}

