#Title: ML_function.R 
#Type: Script
#Version: 1.0
#Date: 2014-03-07
#Author: Martial Sankar
#Maintainer: Martial Sankar <martial.sankar@unil.ch>
#Description: Suite of function for automated cell type recognition.
#License: GPL (>= 2)
#Depends: R (>= 2.14.0)
#OS_type: unix
#Depends on: - 
#URL: http://www3.unil.ch/wpmu/hardtkelab/

# getRunningVectors, function returns a table containing the runnings vectors
#                  @dirRunnings, string, path of the folder containings the runnings image
#                  @sampleN, numeric, if not NULL, sampling  with n = sampleN 
getRunningVectors <- function(dirRunnings,sampleN)
{
	runningVectors <- dir(dirRunnings, full.names =TRUE)
	runningNames <- dir(dirRunnings, full.names =FALSE)
	
	if(!is.null(sampleN)){
		# use only a subset of sampleN images out of 120
		index <- 1:length(runningNames)
		ixsub <- sample(index, sampleN)
		runningVectors <- runningVectors[ixsub]
		runningNames <- runningNames[ixsub]
	}
	
	tabAll<- do.call("rbind",lapply(runningVectors, function(f){read.delim(f, as.is =T, h=T, sep ="\t")}))
	return(tabAll)
	
}

# getTrainingVectorsOvall, function that a list of the training tab takes as input :
#            @ditrain, Sring, training folder directory contains images and xls table
#            @checkViz, Boolean, whether to check by viz
#            @writeTab, Boolean whether to write export training tables
#            @methodExt, String, Methods for ext calculation
getTrainingVectorsOvall <- function(dirtrain, dirseg, rayThresh=NULL,checkViz=TRUE, unitTest=FALSE, writeTab=TRUE ,checkfn,methodExt)
{
	labelCoordsPath <- dir(dirtrain, pattern = "xls", full.names =TRUE)
	labelCoordsName <- dir(dirtrain, pattern = "xls", full.name =FALSE)
	coordTabList <-  lapply(1:length(labelCoordsName), addHeaders, lFull = labelCoordsPath, lnm = labelCoordsName)
	names(coordTabList) <- labelCoordsName
	segImageList <- dir(dirseg, pattern = "segmented.tif", full.names=TRUE)
	imageList <- dir(dirseg, pattern = "segmented.tif", full.names=TRUE)
	rawImageList <- segImageList
	
	trainTabList <- list()
	if(!is.null(checkfn)){
		fnCheckOut <-checkfn
	}
	
	l <- gsub("Results_","",labelCoordsName)
	l <- gsub(".xls","",l)
	n <- length(coordTabList)
	#n <- 2
	for (i in 1:n){
		tabcoord <- labelCoordsPath[i]
		gg <- grep(l[i],segImageList )
		if(length(gg) > 0 ){
			rawImage <- segImageList[gg]
			segImage <-rawImage
			
			# checkFn
			if(!is.null(checkfn)){
				write(paste("\t",strsplit(rawImage,"/")[[1]][length(strsplit(rawImage,"/")[[1]])],"\t",strsplit(segImage,"/")[[1]][length(strsplit(segImage,"/")[[1]])], "\t",strsplit(tabcoord,"/")[[1]][length(strsplit(tabcoord,"/")[[1]])], "\n"), file = fnCheckOut, append =TRUE)
			}
			trainTabList[[i]] <-getTrainingVectors(imSeg =segImage,
					imRaw = rawImage,
					rayThresh = rayThresh,
					labcelltab = tabcoord,
					checkViz=checkViz,
					unitTest=unitTes,
					writeTab=writeTab,
					methodExt=methodExt)
		}
	}
	names(trainTabList) <- labelCoordsName
	return(trainTabList)
	
}



# getTrainingVectorsOvall, function that a list of the training tab takes as input :
#            @imSeg, String or Image Object, Segmented images (ImageJ output)
#            @imRaw, String or Image Object, Raw image (used to generate overlayed segmentation images)
#            @rayThresh, Numeric, filters all objects that have higher radius@ditrain, Sring, training folder directory contains images and xls table
#            @checkViz, Boolean, whether to check by viz
#            @labcelltab, Matrix, contains coordinates of labelled cells
#            @writeTab, Boolean whether to write export training tables
#            @methodExt, String, Methods for ext calculation
getTrainingVectors <- function(imSeg, imRaw=NULL,rayThresh, labcelltab,checkViz=TRUE, unitTest=FALSE, writeTab=TRUE ,methodExt)
{
	ftrsTot <- getFeaturesOverall(imSeg = imSeg, imRaw = imRaw, rayThresh = rayThresh,methodExt=methodExt)
	labs <- extractObjFromFiles(imSeg=imSeg,findObj=TRUE)
	tab <- read.delim(labcelltab, h=T,as.is=T)[,c(1,3:4)]
	lix <- split(tab[,c("X","Y")], tab[,"Type"])
	rm(tab)
	globalListRes <- NULL
	tissueDfRes<- NULL # for viz
	globalListObj <- NULL
	tissueListObj <- NULL
	labObjV <- NULL
	
	for (i in 1:length(lix)){
		for (j in 1:nrow(lix[[i]])){
			rowCurr <- as.matrix(lix[[i]][j,])
			#get object ID
			objId <- as.numeric(labs[rowCurr])
			if(objId!=0){
				dup <- which(tissueListObj==objId)
				if(length(dup)>0){
					tissueListObj <- tissueListObj[-dup]
					labObjV <- labObjV[-dup]
				}#TO DO ALSO REMOVE IN tissueDfRes
				df <- which(labs==objId, arr.ind=TRUE)
				tissueDfRes <- rbind(tissueDfRes,df)
				tissueListObj <- c(tissueListObj,objId)
				labObjV <- c(labObjV, names(lix)[i])
				
			}else {cat("#Label on line !")}
		}
		globalListRes[[i]] <- tissueDfRes
		#globalListObj[[i]] <- tissueListObj
		tissueDfRes <- NULL
	}
	
	cat("#Build result table ...")
	dfres <- NULL
	listObjCurr <- tissueListObj
	#ftrsTissue <- ftrsTot[as.numeric(listObjCurr),]
	ftrsTissue <- ftrsTot[which(row.names(ftrsTot)%in%listObjCurr),]
	tmp <- cbind(as.numeric(row.names(ftrsTissue)),ftrsTissue )
	labObjV<- as.numeric(labObjV)
	for (i in 1:length(labObjV)){
		tmp[which(tmp[,1]==listObjCurr[i]),1]<-labObjV[i]	
	}
	dfres<-tmp 
	cat("DONE!\n")
	
	if(!is.null(writeTab)){
		if(is.character(imRaw)){
			fntmp <- paste( gsub(".tif", "", imRaw),"_trainingVectors.txt", sep ="")
		}else {
			fntmp <- "/home/msankar/tmp/trainingVectors.txt"				
		}		
		write.table(dfres, fntmp, sep="\t", quote=F, row.names=T, col.names=T)
		cat("#Support Vectors in : ", fntmp, "\n")
	}
	
	if(checkViz){
		cat("# Generating mask Images ...")
		colPal <- c("dark blue","cyan","green","orange","pink","red","yellow","dark green","light pink")
		cols <- c("black", rep("white",max(labs)))
		cols <-matrix(cols[1+labs],nrow=dim(labs))
		colsSelect <- cols
		
		for (i in 1:length(globalListRes)){
			pos<- as.matrix(globalListRes[[i]])
			colsSelect[pos] <- colPal[i]
		}
		
		cat(" DONE!\n")
		iNew <- Image(colsSelect)
		
		cat("# Creating Image... \n")
		if(is.character(imRaw)){
			checkgrpnm <- paste( gsub(".tif", "", imRaw),"_checkLab.tif", sep ="")
		}else {
			checkgrpnm <- "/home/msankar/tmp/checkgroup.tif"	
			
		}
		writeImage(iNew, checkgrpnm, quality = 100)
		legend<-TRUE
		if(legend){
			leg <- as.character(names(lix))
			if(is.character(imRaw)){
				nm <- paste( gsub(".tif", "", imRaw),"_legend.pdf", sep ="")
			}else {nm <- "/home/msankar/tmp/legend.pdf"}
			pdf(nm, height = 8, width =8)
			n <- length(lix)
			plot(1:n, 1:n, col = colPal[1:n], cex=10, pch =16)
			text(1:n, 1:n, labels = leg)
			dev.off()
		}
		cat("## saved in : ", checkgrpnm, "\n")
	}
	return(as.data.frame(dfres))
}


# DEPRACTED
# vizClassRes, function that returns segmented images with a mask of the labelled cells
#            @ imSeg, String or Image Object, Segmented images (ImageJ output)
#            @ cellIds, vector, cell ids
#            @ labelIds, vector, cell type label 
#            @ savePref, Boolean, save resulting  images
vizClassRes <- function(imSeg, cellIds, labelIds, suffix=NULL,savePref=TRUE, quarter = TRUE)
{
	labs <- extractObjFromFiles(imSeg=imSeg,findObj=TRUE)
	
	#extract index for each label	
	labels <- unique(labelIds)
	lix <- list()
	ix <-1:length(labelIds)
	for (i in 1:length(labels)){
		cellIdsCurr <- cellIds[which(labelIds==labels[i])]
		ix4viz <- NULL
		for (id in cellIdsCurr){
			df <- which(labs==as.numeric(id), arr.ind=TRUE)
			ix4viz <- rbind(ix4viz,df)
		}		
		lix[[i]] <- as.matrix(ix4viz)
	} # OR USE split
	
	names(lix) <- labels
	cat("# Generating mask Images ...")
	#colPal <- brewer.pal(8, "Accent")
	colPal <- c(brewer.pal(8, "Set2"),brewer.pal(9, "Set1"))
	cols <- c("black", rep("white",max(labs)))
	cols <-matrix(cols[1+labs],nrow=dim(labs))
	colsSelect <- cols
	
	for (i in 1:length(lix)){
		colsSelect[lix[[i]]] <- colPal[i]
	}
	
	cat("# Done\n")
	iNew <- Image(colsSelect)
	cat("# Creating Image... \n")
	if(savePref==TRUE){
		if(is.null(suffix)){
			suffixN <- "checkSVMPreds.tif"
		}else {
			suffixN <- paste( suffix,"_checkSVMPreds.tif", sep ="")
		}
		checkgrpnm <-  paste(gsub("segmented_0.tif","", imSeg) ,suffixN,sep="")
		writeImage(iNew, checkgrpnm, quality = 100)
		cat("## saved in : ", checkgrpnm, "\n")
	}
	
}

# vizClassByColorCircle, function that returns segmented images with a mask of the labelled cells
#            @imSeg, String or Image Object, Segmented images (ImageJ output)
#            @cellIds, vector, cell ids
#            @labelIds, vector, cell type label 
#            @labM, matrix, contains ids, features and label for each cells
#            @savePref, Boolean, save resulting  images
#            @tab, dataFrame, Features table
#            @out, String, output path
vizClassResByColorCircle <- function(imSeg,  tab, cellIds, labelIds, rayThresh=NULL,plotMask = FALSE,  areaThresh=NULL, out )
{
	labs <- extractObjFromFiles(imSeg=imSeg,findObj=TRUE)
	if(is.character(tab)){
		tab <- read.delim(tab, h=T, sep = "\t", as.is=T)
	}else {
		tab<-as.data.frame(tab)
	}
	labels <- unique(labelIds)
	classObjList <- split(cellIds, labelIds)
	
	# define legend lab
	if(!is.null(rayThresh)){
		tab0<-tab
		ut <- which(as.numeric(tab$radiusV)<rayThresh)
		if(length(ut)>0){
			tab<-tab[ut,]
			ids <- row.names(tab)
			rm(tab0)#get cell ids
		}		
	}
	
	if(!is.null(areaThresh)){
		ut <- which(as.numeric(tab$s.area)>areaThresh)
		if(length(ut)>0){
			tab0 <- tab
			tab<-tab[-ut,]
			ids <- row.names(tab0)[-ut]
			rm(tab0)#get cell ids
		}			
	}
	
	# get Ids of table
	nmRow <- row.names(tab)
	cellIdsTot <- as.numeric(unlist(lapply(strsplit(nmRow, ".txt."), function(x){x[[2]]} )))
	colPal <- c(brewer.pal(8, "Set2"),brewer.pal(9, "Set1"))
	tmpName <- paste("checkClasses","_",format(Sys.time(), "%y%m%d%H%M%S"),".pdf",sep="")
	if(is.null(out)){
		checkgrpnm <-  gsub("segmented.tif",tmpName, imSeg)
	}else {
		vsplit <- strsplit(imSeg, "/")[[1]]
		checkgrpnm <- file.path(out, gsub("segmented.tif",tmpName, vsplit[length(vsplit)]))
	}
	labelName <- c( NA,"X", "H", "F","D","C",NA,"Ph", "T", "K")
	pdf(checkgrpnm, height = 16, width = 16)
	
	# plot the mask
	i <- 1
	classObj <- classObjList[[i]]
	coords <- tab[which(cellIdsTot%in%classObj),c("m.cx","m.cy")]
	lsymCur <- labelName[as.numeric(names(classObjList)[i])]
	if (plotMask){
		cols <- c(0, rep(1,max(labs)))
		cols <-matrix(cols[1+labs],nrow=dim(labs))
		colsSelect <- cols
		cex <- 0.1
		cexVal <- 1.4
		plot( which(colsSelect==0, arr.ind = TRUE), pch = 16, cex = 0.1, col = "black")
		points(coords[,1], coords[,2], pch = lsymCur, col = colPal[as.numeric(names(classObjList)[i])], cex =cexVal)
		
	}else {
		cexVal <- 1.4
		
		plot(coords[,1], coords[,2], pch = lsymCur, col = colPal[as.numeric(names(classObjList)[i])], ylim =c(0,dim(labs)[2]) , xlim = c(0,dim(labs)[1]),cex= cexVal)
	}
	legV <- lsymCur
	
	for (i in 2:length(classObjList)){
		classObj <- classObjList[[i]]
		
		coords <- tab[which(cellIdsTot%in%classObj),c("m.cx","m.cy")]
		#output
		lsymCur <- labelName[as.numeric(names(classObjList)[i])]
		points(coords[,1], coords[,2], pch = lsymCur, col = colPal[as.numeric(names(classObjList)[i])], cex=cexVal)
		legV <- c(legV, lsymCur)
		
	}
	
	legend("bottomright", col = colPal[as.numeric(names(classObjList))], legend = legV, pch=16, cex = 3)
	dev.off()
	
}



# extractCortexCellFromLabel, function that returns labelled cortex cells from brachypodium dystachium cross-section
#            @imSeg, String or Image Object, Segmented images (ImageJ output)
#            @tab, dataFrame, Features table
#            @checkViz, Boolean, whether to check by viz
#            @labcelltab, Matrix, contains coordinates of labelled cells
#            @writeTab, Boolean whether to write export training tables
extractCortexCellFromLabel <- function(imSeg, fnRaw=NULL,labcelltab, checkViz=TRUE, unitTest=FALSE, writeTab=NULL)
{
	labs<-extractObjFromFiles(imSeg=imSeg,findObj=TRUE)
	tab <- read.delim(labcelltab, h=T,as.is=T)[,c(1,3:4)]
	lix <- split(tab[,2:3], tab[,1])
	ftrsShape <- computeFeatures.shape(labs)
	ftrsMom <- computeFeatures.moment(labs)
	ftrsTot <- cbind(ftrsShape, ftrsMom)
	cat("## Number of Objects : ", max(labs), "\n")
	
# extract object id and its array of pixels behind each labelled point for each tissue
	globalListRes <- NULL
	tissueDfRes<- NULL # for viz
	globalListObj <- NULL
	tissueListObj <- NULL
	labObjV <- NULL
	for (i in 1:length(lix)){
		for (j in 1:nrow(lix[[i]])){
			rowCurr <- as.matrix(lix[[i]][j,])
			#get object ID
			objId <- as.numeric(labs[rowCurr])
			if(objId!=0){
				dup <- which(tissueListObj==objId)
				if(length(dup)>0){
					tissueListObj <- tissueListObj[-dup]
					labObjV <- labObjV[-dup]
				}#TO DO ALSO REMOVE IN tissueDfRes
				df <- which(labs==objId, arr.ind=TRUE)
				tissueDfRes <- rbind(tissueDfRes,df)
				tissueListObj <- c(tissueListObj,objId)
				labObjV <- c(labObjV, names(lix)[i])
			}
		}
		globalListRes[[i]] <- tissueDfRes
		tissueDfRes <- NULL
	}
	rm(df)
# extract list obj
	cat("# Extracting Features ... ")
	dfres <- NULL
	listObjCurr <- tissueListObj
	ftrsTissue <- ftrsTot[as.numeric(listObjCurr),]
	dfres <-rbind(dfres, cbind(labObjV,ftrsTissue))
	
	dfPolCoord <- getPolarCoord(im=labs, cartCoord=dfres)
	dfres <- cbind(dfres, dfPolCoord)
	
	cat("DONE!\n")
	
	if(!is.null(writeTab)){
		if(is.character(fnRaw)){
			fntmp <- paste( gsub(".tif", "", fnRaw),"_trainingVectors.txt", sep ="")
		}else {
			fntmp <- "/home/msankar/tmp/trainingVectors.txt"				
		}		
		write.table(dfres, fntmp, sep="\t", quote=F, row.names=T, col.names=T)
		cat("#Support Vectors in : ", fntmp, "\n")
	}
	
	
	if(checkViz){
		cat("# Generating mask Images ...")
		colPal <- c("dark blue","cyan","green","orange","pink","red","yellow","dark green","light pink")
		
		cols <- c("black", rep("white",max(labs)))
		cols <-matrix(cols[1+labs],nrow=dim(labs))
		colsSelect <- cols
		
		for (i in 1:length(globalListRes)){
			pos<- as.matrix(globalListRes[[i]])
			colsSelect[pos] <- colPal[i]
		}
		
		cat(" DONE!\n")
		iNew <- Image(colsSelect)
		cat("# Creating Image... \n")

		if(is.character(fnRaw)){
			checkgrpnm <- paste( gsub(".tif", "", fnRaw),"_checkLab.tif", sep ="")
		}else {
			checkgrpnm <- "/home/msankar/tmp/checkgroup.tif"	
		}
		
		writeImage(iNew, checkgrpnm, quality = 100)
		
		legend<-TRUE
		if(legend){
			leg <- as.character(names(lix))
			if(is.character(fnRaw)){
				nm <- paste( gsub(".tif", "", fnRaw),"_legend.pdf", sep ="")
			}else {nm <- "/home/msankar/tmp/legend.pdf"}
			pdf(nm, height = 8, width =8)
			n <- length(lix)
			plot(1:n, 1:n, col = colPal[1:n], cex=10, pch =16)
			text(1:n, 1:n, labels = leg)
			dev.off()
		}
		cat("## saved in : ", checkgrpnm, "\n")
	}
	return(as.data.frame(dfres))
}

# vizClassRes2, function that returns segmented images with a mask of the labelled cells
#            @imSeg, String or Image Object, Segmented images (ImageJ output)
#            @cellIds, vector, cell ids
#            @labelIds, vector, cell type label 
#            @savePref, Boolean, save resulting  images
vizClassRes2 <- function(imSeg, cellIds, labelIds, suffix=NULL,savePref=TRUE, quarter = TRUE)
{
	labs <- extractObjFromFiles(imSeg=imSeg,findObj=TRUE)
	
	#extract index for each label
	labels <- unique(labelIds)
	lix <- list()
	ix <-1:length(labelIds)
	
	cat("# Generating mask Images ...")
	cols <- c(0, rep(1,max(labs)))
	cols <-matrix(cols[1+labs],nrow=dim(labs))
	colsSelect <- cols
	plot( which(colsSelect==0, arr.ind = TRUE), pch = 16)
	cat("# Done\n")
	
	iNew <- Image(colsSelect)
	cat("# Creating Image... \n")
	if(savePref==TRUE){
		
		if(is.null(suffix)){
			suffixN <- "checkSVMPreds.tif"
		}else {
			suffixN <- paste( suffix,"_checkSVMPreds.tif", sep ="")
		}
		checkgrpnm <-  paste(gsub("segmented_0.tif","", imSeg) ,suffixN,sep="")
		#checkgrpnm <- paste(savePref,"_checkGroup.tif",sep="")
		writeImage(iNew, checkgrpnm, quality = 100)
		cat("## saved in : ", checkgrpnm, "\n")
	}
	
}

