'''
Created on 7 aot 2012

@author: Martial
'''


from optparse import OptionParser
import re
import shlex, subprocess, os

if __name__ == '__main__':
    parser = OptionParser()
    parser.add_option("-p", "--pathRaws", dest = "pathRaws", type = "string", action = "store",  help="Folder path containing the raw images", metavar="PATH")    
    parser.add_option("-d", "--das", dest = "das", type = "string", action = "store", help="Number of day after sowing (=age) of the section", metavar="Numeric")
    parser.add_option("-t", "--istif", dest = "istif", type = "string", action = "store", help="if False, convert to tif format", metavar= "BOOLEAN")
    parser.add_option("-l", "--log", dest="log", type = "string",action = "store", default="null", help="log file [null]", metavar="FILE")
    (options, args) = parser.parse_args()
    
    pathRaws =  os.path.normpath(options.pathRaws)
    das =  os.path.normpath(options.das)
    istif = os.path.normpath(options.istif)
    log = os.path.normpath(options.log)
    
    # log 
    if log != "null":
        fw=open(log,"w")
        
    
    #1 convert to TIF Format
    if istif.upper() == "FALSE" :
        print ("#From lsm to tif")
        os.chdir("/home/msankar/local/tools/ImageJ/")
        cml = "/usr/bin/java -jar /home/msankar/local/tools/ImageJ/ij.jar -batch /home/msankar/local/tools/ImageJ/macros/lsm2tif.txt "+pathRaws
        print (cml)
        p = subprocess.Popen(shlex.split(cml), stdout=subprocess.PIPE, stderr=subprocess.PIPE)
        res, err = p.communicate()
        if log != "null":
            fw.write("STEP 1:\n"+cml+"\n"+res)
        
        print("##DONE!!")

    
    
    #2 binarized with R
    
    print ("#Generate bw Image")
    #cml = "/software/R/2.14/bin/R --slave --args "+pathRaws+" "+das+" < /home/msankar/local/secGrowth/dev/script/runGetBinarized.R"
    cml = "/software/R/2.15.1/bin/Rscript /home/msankar/local/secGrowth/dev/script/runGetBinarized.R "+pathRaws+" "+das
    print (cml)
    p = subprocess.Popen(shlex.split(cml), stdout=subprocess.PIPE, stderr=subprocess.PIPE)
    res, err = p.communicate()
    if log != "null":
            fw.write("STEP 2:\n"+cml+"\n"+res)
    print("##DONE!!")

    
    
    #3 ImageJ segmentation
    print ("#ImageJ Segmentation")
    os.chdir("/home/msankar/local/tools/ImageJ/")
    cml = "/usr/bin/java  -jar /home/msankar/local/tools/ImageJ/ij.jar -macro  /home/msankar/local/tools/ImageJ/macros/segFile.txt "+pathRaws
    print (cml)
    p = subprocess.Popen(shlex.split(cml), stdout=subprocess.PIPE, stderr=subprocess.PIPE)
    res, err = p.communicate()
    if log != "null":
        fw.write("STEP 3:\n"+cml+"\n"+res)
        
    print("#DONE!!")

    
    #4 Generate Overlayed Image
    
    print ("#Overlayed Image")
    #cml = "/software/R/2.14/bin/R --slave --args "+pathRaws+" < /home/msankar/local/secGrowth/dev/script/runSaveOverlayedImages.R"     
    cml = "/software/R/2.15.1/bin/Rscript /home/msankar/local/secGrowth/dev/script/runSaveOverlayedImages.R "+pathRaws
    print (cml)
    p = subprocess.Popen(shlex.split(cml), stdout=subprocess.PIPE, stderr=subprocess.PIPE)
    res, err = p.communicate()
    if log != "null":
        fw.write("STEP 4:\n"+cml+"\n"+res)
    
    print("#DONE!!")


    #5 Get Features
    
    print ("#Get Features")
    #cml = "/software/R/2.14/bin/R --slave --args "+pathRaws+" < /home/msankar/local/secGrowth/dev/script/runSaveOverlayedImages.R"     
    cml = "/software/R/2.15.1/bin/Rscript /home/msankar/local/secGrowth/dev/script/runGetFeatures.R "+pathRaws+ " "+das
    print (cml)
    p = subprocess.Popen(shlex.split(cml), stdout=subprocess.PIPE, stderr=subprocess.PIPE)
    res, err = p.communicate()
    if log != "null":
        fw.write("STEP 5:\n"+cml+"\n"+res)
    
    print("#DONE!!")
    
