clc;clear;

load trueK_2 K;
%K=fliplr(K); % uncomment this to run with the mirrored field which
%produces the same concentration data

% set domain parameters for plotting
len     = [75 101];                     % physical length of the domain in x and y direction [m]
Nf      = [75 101];  	                % number of cells in x and y direction
dx      = len./Nf;                      % cell length [m]

% view true K field
figure(1);clf
DisplayVariable(K,len,1,'K [m/s]'), caxis([min(K(:)) max(K(:))]), colorbar, colorbar('location','WestOutside');
% imagesc(flipud(K')); % same with Matlab builtin function

K(K==1)=1e-2;K(K==0)=1e-4; % assign conductivities to facies

% run MaFloT
tic
[p, conc]=MaFloT(K);
toc

% plot pressure field and final saturation field
figure(2);clf
DisplayVariable(p,len,1,'Pressure field [Pa]'), caxis([min(full(p(:))) max(full(p(:)))]), grid on,colorbar;
figure
DisplayVariable(conc(:,:,end),len,1,'Saturation field'), caxis([0 1]), colorbar, colorbar('location','WestOutside');

%% quick and dirty btc plot
%close all;
idat=11;
colors=jet(idat);
iib=[3:7:73];
figure(3);clf
for i=1:idat
    btc(:,i)=conc(iib(i),51,:); % btc contain the uncorrupted simulated measurements
    plot(btc(:,i),'color',colors(i,:),'linewidth',1);hold on
    hold on   
end
axis square
xlabel('Time [d]','fontsize',12);
ylabel('Concentration [kg/m^3]','fontsize',12);
%% Corrupt btc data
stderr=mean(btc(:))*0.03; % measurement error is taken as 3% of the mean of the btc data
btc_c=btc + randn( size(btc) ).*stderr; % btc_c contains the corrupted data used for the inversion

DoPlot='No';
if strcmp(DoPlot,'Yes')
    figure(4);clf
    plot([-0.025:0.01:1],[-0.025:0.01:1],'-k');
    hold on
    plot(btc(:),btc_c(:),'ob')
    xlim([-0.025,0.2]);ylim([-0.025 0.2]);
end
% calculate rmse
err=btc_c(:)-btc(:);
sum(err.^2);
rmse=sqrt(sum(err.^2)./length(err))
%% Create figure 7 of the paper
% Note that subfigure (c) may slightly change due to the use of a different
% seed of the random number generator
%close all;
fsilabel=12;
fsiax=10;
width=0.3;
height=0.65;
lmargin=0.030;
extra_lmargin2=0.03;
extra_lmargin1=0.015;
left1=lmargin+extra_lmargin1;left2=lmargin*2+width-extra_lmargin2;left3=lmargin*3+width*2;
bottom=0.15;
wfact=1.45;
hfact=0.8;

f=figure;
axes1 = axes('Parent',f,...
    'Position',[left1 bottom width height]);
imagesc(flipud(K'));colormap('gray');
xx1=[[3:7:73]',[ones(1,11)*51]'];
hold on;plot(xx1(:,1),xx1(:,2),'ob','Markersize',8,'LineWidth',1.0);
xx2=[14,1;30,1;46,1;62,1;14,101;30,101;46,101;62,101];xx2(:,1)=xx2(:,1)-0.5;
hold on;plot(xx2(:,1),xx2(:,2),'Marker','square','MarkerFaceColor','r','MarkerEdgeColor','r',...
   'Markersize',7,'LineStyle','none'); 
set(gca,'Xtick',[0.5,38.5,75.5],'XtickLabel',{'0','38','75'},'Ytick',[0.5,51.5,101.5],'YtickLabel',{'101','51','0'});
set(gca,'FontSize',fsiax);
xl=xlabel('\it x\rm-distance (m)','fontsize',fsilabel);
yl=ylabel('\it y\rm-distance (m)','fontsize',fsilabel);
axis equal tight
Posi(1,:)=get(gca,'position');

axes2 = axes('Parent',f,...
    'Position',[left2 bottom width height]);
imagesc((K'));colormap('gray');
hold on;plot(xx1(:,1),xx1(:,2),'ob','Markersize',8,'LineWidth',1.0);
hold on;plot(xx2(:,1),xx2(:,2),'Marker','square','MarkerFaceColor','r','MarkerEdgeColor','r',...
   'Markersize',7,'LineStyle','none');
set(gca,'Xtick',[0.5,38.5,75.5],'XtickLabel',{'0','38','75'},'Ytick',[0.5,51.5,101.5],'YtickLabel',[],'FontSize',fsiax);
xl=xlabel('\it x\rm-distance (m)','fontsize',fsilabel);
axis equal tight  
Posi(2,:)=get(gca,'position');

axes3 = axes('Parent',f,...
    'Position',[left3 bottom width height]);
plot(-1:0.1:1.1,-1:0.1:1.1,'-k');
hold on;plot(btc,btc_c,'ok');
xlim([-0.01 0.2]);ylim([-0.01 0.2]);
set(gca,'FontSize',fsiax);
set(gca,'Xtick',[0:0.05:0.2],'Ytick',[0:0.05:0.2]);
axis square;
xlabel('True data (kg/m^3)','fontsize',fsilabel);
ylabel('Corrupted data (kg/m^3)','fontsize',fsilabel);
Posi(3,:)=get(gca,'position');

posi=get(f,'position');
  set(f,'position',[posi(1) posi(2), posi(3)*wfact posi(4)*hfact]);
  annotation(gcf,'textbox',...
    [Posi(1,1)+0.06  Posi(1,2)+0.72 0.25 0.05],...
    'String',{'(a) Reference field'},...
    'Fontsize',fsilabel,...
    'FontName','Arial',...
    'FitBoxToText','off',...
    'EdgeColor','None');
annotation(gcf,'textbox',...
    [Posi(2,1)+0.02  Posi(2,2)+0.72 0.25 0.05],...
    'String',{'(b) Mirrored reference field'},...
    'Fontsize',fsilabel,...
    'FontName','Arial',...
    'FitBoxToText','off',...
    'EdgeColor','None');
annotation(gcf,'textbox',...
    [Posi(3,1)+0.08  Posi(2,2)+0.72 0.25 0.05],...
    'String',{'(c) Noise level'},...
    'Fontsize',fsilabel,...
    'FontName','Arial',...
    'FitBoxToText','off',...
    'EdgeColor','None');
annotation(gcf,'textbox',...
    [Posi(3,1)+0.075  Posi(3,2)+0.05 0.3 0.05],...
    'String',{['RMSE = ',num2str(rmse,'%1.4f'),' m']},...
    'Fontsize',fsilabel-1,...
    'FontName','Arial',...
    'FitBoxToText','off',...
    'EdgeColor','None');
%% Compare uncorrupted btc data obtained from reference and mirrored reference fields
clc;clear; %close all;
load btc_comp;
% quick and dirty  plot
% circles and crosses denote data derived from using the reference and mirrored 
% reference fields, respectively.
idat=11;
colors=jet(idat);
iib=[3:7:73];
figure(5);clf
for i=1:idat
    plot(btc1(:,i),'LineStyle','--','Marker','o','MarkerFaceColor','None',...
        'MarkerEdgeColor',colors(i,:),'linewidth',1);hold on
    plot(btc2(:,i),'LineStyle','--','Marker','x','MarkerFaceColor','None',...
        'MarkerEdgeColor',colors(i,:),'linewidth',1);hold on 
end
axis square
xlabel('Time [d]','fontsize',12);
ylabel('Concentration [kg/m^3]','fontsize',12);