clc;clear;

load trueK_1 K;

% set domain parameters for plotting
len     = [100 100];                    % physical length of the domain in x and y direction [m]
Nf      = [100 100];  	                % number of cells in x and y direction
dx      = len./Nf;                      % cell length [m]

% view true K field
figure(1);clf
DisplayVariable(K,len,1,'K [m/s]'), caxis([min(K(:)) max(K(:))]), colorbar, colorbar('location','WestOutside');
% imagesc(flipud(K')); % same with Matlab builtin function

K(K==1)=1e-2;K(K==0)=1e-4; % assign conductivities to facies

% set coordinates of synthetic "measurement" data
id_xy=[20 20; 35 35;65 65;80 80; 20 80; 80 20;  35 65; 65 35; 51 51; 51 65; 51 35; 35 51; 65 51;...
    20 35; 20 51; 20 65; 35 20; 51 20; 65 20; 80 35; 80 51; 80 65; 35 80; 51 80; 65 80
    5 5; 5 20; 5 35; 5 51; 5 65; 5 80 ; 5 95; 20 5; 35 5; 51 5; 65 5; 80 5; 95 5; ...
    95 20; 95 35; 95 51; 95 65; 95 80; 95 95; 20 95; 35 95; 51 95; 65 95; 80 95];

% run MaFloT
tic
[p, conc]=MaFlo_(K) ; % MaFlo_.m calculates only the steady-state pressure field
toc

% plot pressure field
figure(2);clf
pm=p./9810; % convert Pa to water column (m) assuming gravity is 9.81 [m/s2]
DisplayVariable(pm,len,1,'Pressure field [m]'), caxis([min(full(pm(:))) max(full(pm(:)))]), grid on,colorbar;
hold on % add head measurement locations
plot(id_xy(:,1),id_xy(:,2),'ks');
grid('off');
%% Create corrputed head data
head_data=zeros(size(id_xy,1),1);
for i=1:size(id_xy,1)
    head_data(i,1)=pm(id_xy(i,1),id_xy(i,2));
end
stderr=0.01; % standard deviation of the measurement error
head_data_c=head_data + randn( size(head_data) )*stderr;
% head_data_c contains the corrupted head data used for the inversion
DoPlot='No';
if strcmp(DoPlot,'Yes')
    figure(3);clf
    plot([-1:0.01:1],[-1:0.01:1],'-k');
    hold on
    plot(head_data(:),head_data_c(:),'ob')
end
% check rmse
err=head_data_c(:)-head_data(:);
sum(err.^2);
rmse=sqrt(sum(err.^2)./length(err))
%% Create figure 1 of the paper
% Note that subfigure (c) may slightly change due to the use of a different
% seed of the random number generator
fsilabel=12;
fsiax=10;
width=0.3;
height=0.65;
lmargin=0.035;
extra_lmargin2=0.03;
extra_lmargin1=0.015;
left1=lmargin+extra_lmargin1;left2=lmargin*2+width-extra_lmargin2;left3=lmargin*3+width*2;
bottom=0.15;
wfact=1.45;
hfact=0.8;

f=figure;
axes1 = axes('Parent',f,...
    'Position',[left1 bottom width height]);
imagesc(flipud(K'));colormap('gray');
hold on;plot([51,51],[51,51],'ob','Markersize',8,'LineWidth',1.5);
hold on;plot(id_xy(:,1),id_xy(:,2),'xr','Markersize',8,'LineWidth',1.0);
set(gca,'Xtick',[0.5,50.5,100.5],'XtickLabel',{'0','50','100'},'Ytick',[0.5,50.5,100.5],'YtickLabel',{'0','50','100'});
axis square;
set(gca,'FontSize',fsiax);
xl=xlabel('\it x\rm-distance (m)','fontsize',fsilabel);
yl=ylabel('\it y\rm-distance (m)','fontsize',fsilabel);
axis square;
Posi(1,:)=get(gca,'position');

axes2 = axes('Parent',f,...
    'Position',[left2 bottom width height]);
[C,h] = contourf(flipud(pm'),15);
texth=clabel(C,h,'fontsize', 10);
tt=str2double(get(texth,'String'));
v=sort(tt);v=unique(v);vl=v(1:2:end);
%texth=clabel(C,h,vl,'fontsize', 10);
for i=1:size(texth)
    textstr=get(texth(i),'String');
    textnum=str2double(textstr);
    textstrnew=sprintf('%1.1f', textnum);
    set(texth(i),'String',textstrnew);
end
hold on;plot([51,51],[51,51],'ob','Markersize',8,'LineWidth',1.5);
hold on;plot(id_xy(:,1),id_xy(:,2),'xr','Markersize',8,'LineWidth',1.0);
set(gca,'Xtick',[0,50,100],'XtickLabel',{'0','50','100'},'Ytick',[0,50,100],'YtickLabel',[]);
axis square;
set(gca,'FontSize',fsiax);
xl=xlabel('\it x\rm-distance (m)','fontsize',fsilabel);
axis square;
Posi(2,:)=get(gca,'position');

axes3 = axes('Parent',f,...
    'Position',[left3 bottom width height]);
plot(-1:0.1:1.1,-1:0.1:1.1,'-k');
hold on;plot(head_data,head_data_c,'ok');
xlim([-0.3 1]);ylim([-0.3 1]);
set(gca,'FontSize',fsiax);
set(gca,'Xtick',[-0.2:0.6:1],'Ytick',[-0.2:0.6:1]);
axis square;
xlabel('True heads (m)','fontsize',fsilabel);
ylabel('Corrupted heads (m)','fontsize',fsilabel);
Posi(3,:)=get(gca,'position');
posi=get(f,'position');
set(f,'position',[posi(1) posi(2), posi(3)*wfact posi(4)*hfact]);
annotation(gcf,'textbox',...
    [Posi(1,1)+0.06  Posi(1,2)+0.72 0.25 0.05],...
    'String',{'(a) Reference field'},...
    'Fontsize',fsilabel,...
    'FontName','Arial',...
    'FitBoxToText','off',...
    'EdgeColor','None');
annotation(gcf,'textbox',...
    [Posi(2,1)+0.05  Posi(2,2)+0.72 0.25 0.05],...
    'String',{'(b) Reference heads'},...
    'Fontsize',fsilabel,...
    'FontName','Arial',...
    'FitBoxToText','off',...
    'EdgeColor','None');
annotation(gcf,'textbox',...
    [Posi(3,1)+0.07  Posi(2,2)+0.72 0.25 0.05],...
    'String',{'(c) Noise level'},...
    'Fontsize',fsilabel,...
    'FontName','Arial',...
    'FitBoxToText','off',...
    'EdgeColor','None');
annotation(gcf,'textbox',...
    [Posi(3,1)+0.12  Posi(3,2)+0.05 0.3 0.05],...
    'String',{['RMSE = ',num2str(rmse,'%1.2f'),' m']},...
    'Fontsize',fsilabel-1,...
    'FontName','Arial',...
    'FitBoxToText','off',...
    'EdgeColor','None');
